
#include <tqstring.h>
#include "core/polkit-tqt-authority.h"

#define TEST_PASSED 0
#define TEST_FAILED 1

using namespace PolkitTQt;

int main(void)
{
  // This needs the file org.tqt.policykit.examples.policy from examples to be installed
  UnixProcessSubject process(getpid());
  Authority::Result result;
  // Check if this method returns good authorization results
  Authority *authority = Authority::instance();
  result = authority->checkAuthorizationSync("org.tqt.policykit.examples.kick", process, Authority::None);
  if (result != Authority::No)
  {
    return TEST_FAILED;
  }
  if (authority->hasError())
  {
    return TEST_FAILED;
  }
  result = authority->checkAuthorizationSync("org.tqt.policykit.examples.cry", process, Authority::None);
  if (result != Authority::Yes)
  {
    return TEST_FAILED;
  }
  if (authority->hasError())
  {
    return TEST_FAILED;
  }
  result = authority->checkAuthorizationSync("org.tqt.policykit.examples.bleed", process, Authority::None);
  if (result != Authority::Challenge)
  {
    return TEST_FAILED;
  }
  if (authority->hasError())
  {
    return TEST_FAILED;
  }

  // Check if it can cancel user authentication dialog
  authority->checkAuthorization("org.tqt.policykit.examples.bleed", process, Authority::AllowUserInteraction);
  // Show it for second
  sleep(1);
  // And now kill it
  authority->checkAuthorizationCancel();
  if (authority->hasError())
  {
    return TEST_FAILED;
  }
  // But how to test if it was successful?
  tqWarning("You should see an authentication dialog for a short period.");

  return TEST_PASSED;
}
