/***************************************************************************
 *   Copyright (C) 2003 by Antonio Fasolato                                *
 *   Antonio.Fasolato@poste.it                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "options.h"

#include <iostream>
#include <map>
using namespace std;

#include <tqstring.h>

Options::Options(): options()
{
}

void Options::setValue(TQString key, TQString value) {
	if(options.find(key)!=options.end())
		options.erase(options.find(key));
	map<TQString,TQString>::value_type v(key,value);
	options.insert(v);
}

bool Options::isEmpty() {
	return options.empty();
}

void Options::clear() {
	options.clear();
}

TQString Options::operator[](TQString key) {
	if(options.find(key)!=options.end())
		return options[key];
	else
		return "";
}

void Options::defaultOptions(){
	clear();

	//input-output
	setValue("blackLevel","0.5");
 	setValue("invertInput","n");
 	setValue("outputFileName","");
 	setValue("outputFormat","eps");
	setValue("pageSize","letter");
	setValue("optimizedNumericalCode","y");
	setValue("compressionLevel","2");

	//Color
	setValue("foregroundBtn","#000000");
	setValue("backgroundBtn","#F8F9FB");

 	//Algorithm
 	setValue("policy","4");
 	setValue("despeckle","0");
 	setValue("cornerThreshold","1.00");
 	setValue("optimizationTolerance","0.2");
 	setValue("outputQuantization","10");
 	setValue("curveOptimization","y");

 	//Transformation
 	setValue("width","0.0");
 	setValue("height","0.0");
 	setValue("stretch","1.0");
 	setValue("rotation","0.0");

 	//Resolution
 	setValue("resolution","0.0");

 	//Margins
	setValue("syncronizeMargins","y");
	setValue("margins","0.0");
}

void Options::debug() {
	for(map<TQString,TQString>::iterator i=options.begin(); i!=options.end(); i++)
		cout << (*i).first.local8Bit() << "=" << (*i).second.local8Bit() << endl;
}


