#!/usr/bin/env python
""" About the PyTDE Sampler

Defines the 'about' function to create a TDEAboutData instance for the
sampler application.
"""
from os.path import dirname, join
from tdecore import TDEAboutData


appName = b'pytdesampler'
progName = b'PyTDE Sampler'
authorName = b'Troy Melhase'
authorEmail = bugsEmailAddress = b'troy@gci.net'
version = b'0.1'
shortDescription = b'The PyTDE Sampler'
licenseType = TDEAboutData.License_GPL_V2
copyrightStatement = '(c) 2006, Troy Melhase'
homePageAddress = b'http://www.riverbankcomputing.co.uk/pytde/'
aboutText = (b"The application sampler for PyTDE.")
contributors = [] # module-level global for keeping the strings around; intentional


def about():
    """ creates TDEAboutData instance for the app

    """
    about = TDEAboutData(
        appName,
        progName,
        version,
        shortDescription,
        licenseType,
        copyrightStatement,
        aboutText,
        homePageAddress,
        bugsEmailAddress)
    about.addAuthor(authorName, '', authorEmail)

    try:
        contrib = open(join(dirname(__file__), 'contributors.txt'))
        contrib = [line.strip() for line in contrib]
        contrib = [line for line in contrib if not line.startswith('#')]
        for line in contrib:
            try:
                name, task, addr = [s.strip() for s in line.split(',')]
                contributors.append((name, task, addr))                            
            except:
                pass
    except:
        pass

    contributors.sort(lambda a, b:cmp(a[0], b[0]))
    for name, task, addr in contributors:
        about.addCredit(name, task, addr)

    return about
