#!/usr/bin/env python

# TQt tutorial 7.

import sys
from PyTQt import tqt


class LCDRange(tqt.TQVBox):
    def __init__(self, parent=None, name=None):
        tqt.TQVBox.__init__(self, parent, name)

        lcd = tqt.TQLCDNumber(2, self, "lcd")
        self.slider = tqt.TQSlider(tqt.TQt.Horizontal, self, "slider")
        self.slider.setRange(0, 99)
        self.slider.setValue(0)
        self.connect(self.slider, tqt.TQ_SIGNAL("valueChanged(int)"), lcd, tqt.TQ_SLOT("display(int)"))
        self.connect(self.slider, tqt.TQ_SIGNAL("valueChanged(int)"), self, tqt.PYSIGNAL("valueChanged(int)"))

    def value(self):
        return self.slider.value()

    def setValue(self, value):
        self.slider.setValue(value)


class MyWidget(tqt.TQVBox):
    def __init__(self, parent=None, name=None):
        tqt.TQVBox.__init__(self, parent, name)

        quit = tqt.TQPushButton("Quit", self, "quit")
        quit.setFont(tqt.TQFont("Times", 18, tqt.TQFont.Bold))

        self.connect(quit, tqt.TQ_SIGNAL("clicked()"), tqt.tqApp, tqt.TQ_SLOT("quit()"))

        grid = tqt.TQGrid(4, self)

        self.lcdlist = []
        previous = None

        for r in range(4):
            for c in range(4):
                lr = LCDRange(grid)

                if previous:
                    self.connect(lr, tqt.PYSIGNAL("valueChanged(int)"), previous.setValue)

                previous = lr
                self.lcdlist.append(lr)


a = tqt.TQApplication(sys.argv)

w = MyWidget()
a.setMainWidget(w)
w.show()
sys.exit(a.exec_loop())
