/***************************************************************************
    main.cpp  -  Main file of the Smb4K program.
                             -------------------
    begin                : Sam M�  1 14:57:21 CET 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// TQt includes
#include <tqstringlist.h>
#include <tqfile.h>

// KDE includes
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <tdelocale.h>
#include <kiconloader.h>
#include <dcopclient.h>
#include <tdeconfig.h>
#include <kuniqueapplication.h>
#include <tdemessagebox.h>
#include <kstandarddirs.h>

// system includes
#include <stdlib.h>

// application specific includes
#include "smb4k.h"
#include "core/smb4ksettings.h"
#include "core/smb4kcore.h"


static const char *description =
  I18N_NOOP( "Smb4K is an advanced network neighborhood browser and a\n"
             "front end to the programs of the Samba software suite." );

static TDECmdLineOptions options[] =
{
//   { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};


int main( int argc, char *argv[] )
{
  TDEAboutData aboutData( "smb4k", I18N_NOOP( "Smb4K" ),
  VERSION, description, TDEAboutData::License_GPL,
  I18N_NOOP( "(c) 2003-2008, Alexander Reinholdt\n(c) 2004-2008, Massimo Callegari\n(c) 2004, Franck Babin" ), 0, "http://smb4k.berlios.de", "smb4k-bugs@lists.berlios.de" );

  // Authors:
  aboutData.addAuthor( "Alexander Reinholdt", I18N_NOOP( "Developer" ), "dustpuppy@users.berlios.de" );
  aboutData.addAuthor( "Massimo Callegari", I18N_NOOP( "Developer" ), "massimocallegari@yahoo.it" );
  aboutData.addAuthor( "Franck Babin", I18N_NOOP( "Developer" ), "babinfranck@yahoo.ca" );

  // All our credits:
  aboutData.addCredit( "Leopold Palomo Avellaneda", I18N_NOOP( "Catalan translation" ), "lepalom@wol.es" );
  aboutData.addCredit( "Radoslaw Zawartko", I18N_NOOP( "Polish translation" ), "radzaw@lnet.szn.pl" );
  aboutData.addCredit( "Nick Chen", I18N_NOOP( "Chinese Simplified translation" ), "nick_chen75@hotmail.com" );
  aboutData.addCredit( "Stanislav Yudin", I18N_NOOP( "Russian translation" ), "decvar@mail.berlios.de" );
  aboutData.addCredit( "Marc Hansen", I18N_NOOP( "Swedish translation and intensive testing" ), "marc.hansen@gmx.de" );
  aboutData.addCredit( "Giovanni Degani", I18N_NOOP( "Brazilian Portuguese translation" ), "tiefox@terra.com.br" );
  aboutData.addCredit( "Ivan Petrouchtchak", I18N_NOOP( "Ukrainian translation" ), "iip@telus.net" );
  aboutData.addCredit( "Karoly Barcza", I18N_NOOP( "Hungarian translation" ), "kbarcza@blackpanther.hu" );
  aboutData.addCredit( "Quique", I18N_NOOP( "Spanish translation" ), "quique@sindominio.net" );
  aboutData.addCredit( "Michal Šulek", I18N_NOOP( "Slovak translation" ), "reloadshot@atlas.sk" );
  aboutData.addCredit( "Nicolas Ternisien", I18N_NOOP( "French translation" ), "nicolast@libertysurf.fr" );
  aboutData.addCredit( "Toyohiro Asukai", I18N_NOOP( "Japanese translation" ), "toyohiro@ksmplus.com" );
  aboutData.addCredit( "Atanas Mavrov", I18N_NOOP( "Bulgarian translation" ), "bugar@developer.bg" );
  aboutData.addCredit( "Isidoro Russo", I18N_NOOP( "Italian translation" ), "risidoro@aliceposta.it" );
  aboutData.addCredit( "Nils Kristian Tomren", I18N_NOOP( "Norwegian translations" ), "project@nilsk.net" );
  aboutData.addCredit( "Alois Nešpor", I18N_NOOP( "Czech translation" ), "alois.nespor@seznam.cz" );
  aboutData.addCredit( "Martín Carr", I18N_NOOP( "Spanish translation" ), "tincarr@gmail.com" );
  aboutData.addCredit( "Görkem Çetin", I18N_NOOP( "Turkish translation" ), "gorkem@gorkemcetin.com" );
  aboutData.addCredit( "Jack Liu", I18N_NOOP( "Chinese Traditional translation" ), "chuany@chuany.net" );
  aboutData.addCredit( "Arnar Leósson", I18N_NOOP( "Icelandic translation" ), "leosson@frisurf.no" );
  aboutData.addCredit( "Michael Brinkloev", I18N_NOOP( "Danish translation" ), "mhb@qxp.dk" );
  aboutData.addCredit( "Joop Beris", I18N_NOOP( "Dutch translation" ), "jberis@risse.nl" );
  aboutData.addCredit( "Lamarque V. Souza", I18N_NOOP( "Brazilian Portuguese translation" ), "lamarque_souza@hotmail.com" );
  aboutData.addCredit( "Serdar Soytetir", I18N_NOOP( "Turkish translation" ), "sendirom@gmail.com" );
  aboutData.addCredit( "Wei-Lun Chao", I18N_NOOP( "Chinese Traditional translation" ), "chaoweilun@users.berlios.de" );
  aboutData.addCredit( "Rashid N. Achilov", I18N_NOOP( "Testing of Smb4K under FreeBSD" ), "shelton@sentry.granch.ru" );
  aboutData.addCredit( "Jerzy Trzeciak", I18N_NOOP( "Polish translation" ), "artusek@wp.pl" );

  TDECmdLineArgs::init( argc, argv, &aboutData );
  TDECmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KUniqueApplication::addCmdLineOptions();

  // This is not needed, because KUniqueApplication::start()
  // is called directly before the application is executed, but
  // we use it anyway. There is no performance impact.
  if ( !KUniqueApplication::start() )
  {
    exit( 0 );
  }

  KUniqueApplication app;

  // Check the current config file and remove it if it belongs to
  // a version < 0.9.0.
  TDEConfig config( "smb4krc", false, false, "config" );

  if ( !config.groupList().isEmpty() &&
       (config.groupList().contains( "Browse Options" ) != 0 ||
        config.groupList().contains( "Mount Options" ) != 0 ||
        config.groupList().contains( "Rsync" ) != 0 ||
        config.groupList().contains( "Super User Privileges") != 0 ||
        config.groupList().contains( "User Interface" ) != 0 ||
        config.groupList().contains( "System" ) != 0) )
  {
    int return_value = KMessageBox::warningContinueCancel( 0, i18n( "Smb4K now uses a different configuration system. Thus, your old settings are obsolete and you have to reconfigure the application.\nTo assure a clean transition, the current configuration file will be removed." ) );

    if ( return_value == KMessageBox::Continue )
    {
      TQString file_name = locateLocal( "config", "smb4krc", false );

      if ( !file_name.isEmpty() && TQFile::exists( file_name ) )
      {
        TQFile::remove( file_name );
      }
    }
    else
    {
      exit( 0 );
    }
  }

  // Launch the application:
  Smb4KApp *smb4k = new Smb4KApp( 0, "MainApp" );

  app.setMainWidget( smb4k );

  if ( !Smb4KSettings::embedIntoSystemTray() || !Smb4KSettings::startMainWindowDocked() )
  {
    smb4k->show();
  }

  Smb4KCore::self()->init();

  int result = app.exec();

  return result;
}
