/***************************************************************************
 *   Copyright (C) 2006 by Marco Martin   *
 *   notmart@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "tastytooltip.h"

#include <tqlabel.h>
#include <tqtimer.h>
#include <kiconloader.h>
#include <kdebug.h>
#include <tqbutton.h>


TastyToolTip::TastyToolTip( TQWidget * parent,const char * name, WFlags fl)
  : TQWidget(parent, name, fl|WX11BypassWM )
{
  iconName = "kmenu";
  tastyToolTipLayout = new TQVBoxLayout( this, 0, 0, "tastyToolTipLayout"); 
  toolTipWidget = new TastyToolTipWidget(this);
  tastyToolTipLayout->addWidget(toolTipWidget);
}


void TastyToolTip::loadIcon( TQString icon )
{
  iconName = icon;
  TDEIconLoader *iconLoader = TDEGlobal::iconLoader();
  TQPixmap btnPixmap(iconLoader->loadIcon(icon, TDEIcon::Panel, TDEIcon::SizeHuge));

  if( !btnPixmap.isNull() )
    toolTipWidget->iconPixmap->setPixmap(btnPixmap);
  else
  {
    kdDebug() << "Failed to load custom icon" << endl;
    toolTipWidget->iconPixmap->setPixmap(iconLoader->loadIcon("kmenu", TDEIcon::Panel, TDEIcon::SizeHuge));
  }
}

TastyToolTip::~TastyToolTip()
{
}


void TastyToolTip::showTip(const TQPoint & point)
{
  move(point);
  TQTimer::singleShot(250, this, TQ_SLOT(show()));
}

void TastyToolTip::show()
{
  TQButton *button  = dynamic_cast<TQButton *>(parent());
  if(button && button->hasMouse() && !button->isDown())
    TQWidget::show();
}

void TastyToolTip::hideTip( )
{
  TQTimer::singleShot(250, this, TQ_SLOT(hide()));
}

void TastyToolTip::notify(const TQPoint & point )
{
  move(point);
  show();
  TQTimer::singleShot(5000, this, TQ_SLOT(hide()));
}

void TastyToolTip::setMessage( TQString message )
{
  TDEIconLoader *iconLoader = TDEGlobal::iconLoader();
  toolTipWidget->MessageLabel->setText(message);

  if( message.length() > 0 )
    toolTipWidget->iconPixmap->setPixmap(iconLoader->loadIcon("messagebox_info", TDEIcon::Panel, TDEIcon::SizeHuge));
  else
    loadIcon(iconName);
}

void TastyToolTip::setTitle( TQString title )
{
  if( !title.isEmpty() )
    toolTipWidget->appNameLabel->setText( title );
}

