/***************************************************************************
 *   Copyright (C) 2004 by Thomas Lübking                                  *
 *   thomas@home                                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _BAB_H_
#define _BAB_H_

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
//#include <dcopclient.h>
#include "bab_iface.h"
#include <tqwidget.h>
#include <tqpixmap.h>
#include <tqsettings.h>
#include <tdemainwindow.h>
#include <ksystemtray.h>

class bab;

class BabSwitcher : public KSystemTray , public babInterface{
   TQ_OBJECT
public: 
   
   enum State {Jaguar = 0, Panther, iTunes, Tiger, Milk};

   BabSwitcher(bab *parent=0, const char *name=0);
   ~BabSwitcher();

   void toggle();
   void setStyle(TQString);
   TQString style();
   void setDeco(TQString);
   TQString deco();
   void start(TQString name, TQString settings);
   void emitStyleChanged();
   static TQPoint *globalPos;
   
protected:
   void mousePressEvent(TQMouseEvent *e);
   void paintEvent(TQPaintEvent *ev);

private:

   int state_;
   int decoState_;
   TQPixmap JaguarIcon;
   TQPixmap PantherIcon;
   TQPixmap iTunesIcon;
   TQPixmap TigerIcon;
   TQPixmap MilkIcon;
};


class TQComboBox;
class TQCheckBox;
/**
 * @short Application Main Window
 * @author Thomas Lübking <baghira-style@gmx.net>
 * @version 0.1
 */
class bab : public TDEMainWindow
{
    TQ_OBJECT
public:
    
    enum TabState {Tab = 0, Clever, Chooser};
    bab();
    void showEvent(TQShowEvent *e);
   TQCheckBox *cornerCheck;
    virtual ~bab();
private:
    BabSwitcher* bSwitcher;
    TQComboBox *DefStyle;

private slots:
   void saveSettings();
   void configureBaghira();

};

class Corner : public TQWidget
{
    TQ_OBJECT
    public:
        enum Side {left = 0, right};
        Corner(Side side);
public slots:
    void toggle(bool);
};

#endif // _BAB_H_
