#ifndef COLORPICKER_H
#define COLORPICKER_H

//#include <tqvariant.h>
#include <tqgroupbox.h>

class TQSlider;
class TQSpinBox;
class TQColor;
//class TQGroupBox;

class ColorPicker : public TQGroupBox
{
    TQ_OBJECT

public:
    ColorPicker( TQWidget* parent = 0, const char* name = 0);
    ~ColorPicker();
    TQColor Color();

public slots:
    void setColor(TQColor color);
    void setRed(int red);
    void setGreen(int green);
    void setBlue(int blue);
    void reset();
    void init();
    
protected:
    TQSlider *redSlider;
    TQSlider *greenSlider;
    TQSlider *blueSlider;
    TQSpinBox *redValue;
    TQSpinBox *greenValue;
    TQSpinBox *blueValue;
    TQColor color_;
//    TQGroupBox *box;

signals:
    void colorChanged(TQColor color);

};

#endif // COLORPICKER_H
