
#ifndef LINKVIEW_H
#define LINKVIEW_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tqscrollview.h>

class ListBoxLink;
class DnDListBox;
class MediaListBox;

class LinkView : public TQScrollView
{
    TQ_OBJECT
    
public:
     LinkView(TQWidget * parent = 0, const char * name = 0, WFlags f = 0);

    /** destructor */
    ~LinkView();
   MediaListBox *Hardware(){return hardware;}
   DnDListBox *Locations(){return locations;}
   void loadLinks();
   void saveLinks();

protected:
   void viewportResizeEvent( TQResizeEvent * );
   bool eventFilter(TQObject *, TQEvent *);
private:
   MediaListBox *hardware;
   DnDListBox *locations;
   TQSplitter *splitter;
   bool _blocked;
   uint loadedLinks;
private slots:
   void postInstallEventFilter();
   void unselectLocations();
   void unselectHardware();
   void adjustSplitter2Locations();
   void adjustSplitter2Hardware(bool added);
};

#endif
