//////////////////////////////////////////////////////////////////////////////
// polyester.h
// -------------------
// Polyester window decoration for KDE
// Copyright (c) 2005 Marco Martin <notmart@gmail.com>
// -------------------
// derived from Smooth Blend
// Copyright (c) 2005 Ryan Nickell <p0z3r@users.sourceforge.net>
// -------------------
// Shadow engine from Plastik decoration
// Copyright (C) 2003 Sandro Giessl <ceebx@users.sourceforge.net>
// -------------------
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by 
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the
//   Free Software Foundation, Inc.,
//   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//////////////////////////////////////////////////////////////////////////////

#ifndef polyester_H
#define polyester_H

#include <tqbutton.h>
#include <kdecoration.h>
#include <kdecorationfactory.h>

#define TITLEBAR_GLASS     1

#define BUTTON_GRADIENT    0
#define BUTTON_GLASS       1
#define BUTTON_REVGRADIENT 2
#define BUTTON_FLAT        3

class TQSpacerItem;
class TQPoint;

namespace polyester {

class polyesterClient;

enum ButtonType {
    ButtonHelp=0,
    ButtonMax,
    ButtonMin,
    ButtonClose,
    ButtonMenu,
    ButtonSticky,
    ButtonAbove,
    ButtonBelow,
    ButtonShade,
    ButtonTypeCount
};

// polyesterFactory /////////////////////////////////////////////////////////
//
// add variables and flags for config like...
//
// public:  type function()
// private: type var_
// inline type function(){ return var_ };
//

class polyesterFactory: public KDecorationFactory {
public:
    polyesterFactory();
    virtual ~polyesterFactory();
    virtual KDecoration *createDecoration(KDecorationBridge *b);
    virtual bool reset(unsigned long changed);
    static bool initialized();
    static TQt::AlignmentFlags titleAlign();
    static int contrast();
    static bool roundedCorners();
    static int titleSize();
    static int buttonSize();
    static bool squareButton();
    static int frameSize();
    static int roundSize();
    static TQFont titleFontTool() { return m_titleFontTool; }
    static bool titleShadow();
    static int titleBarStyle() { return titleBarStyle_;}
    static int buttonStyle() { return buttonStyle_;}
    static bool animateButtons() { return animatebuttons; }
    static bool noModalButtons() { return nomodalbuttons; }
    static bool lightBorder() { return lightBorder_; }
    static int getBtnComboBox() { return btnComboBox; }
    static bool menuClosed() { return menuClose; }

private:
    bool readConfig();

private:
    static bool initialized_;
    static TQt::AlignmentFlags titlealign_;
    static int contrast_;
    static bool cornerflags_;
    static int titlesize_;
    static int buttonsize_;
    static bool squareButton_;
    static bool lightBorder_;
    static int framesize_;
    static int titleBarStyle_;
    static int buttonStyle_;
    static int roundsize_;
    static TQFont m_titleFontTool;
    static bool titleshadow_;
    static bool animatebuttons;
    static bool nomodalbuttons;
    static int btnComboBox;
    static bool menuClose;
};

inline bool polyesterFactory::initialized() {
    return initialized_;
}
inline TQt::AlignmentFlags polyesterFactory::titleAlign() {
    return titlealign_;
}

inline int polyesterFactory::contrast(){
   return contrast_;
}

inline bool polyesterFactory::roundedCorners() {
    return cornerflags_;
}
inline int polyesterFactory::titleSize() {
    return titlesize_;
};
inline int polyesterFactory::buttonSize() {
    return buttonsize_;
};
inline bool polyesterFactory::squareButton() {
  return squareButton_;
};
inline int polyesterFactory::frameSize() {
    return framesize_;
};
inline int polyesterFactory::roundSize() {
    return roundsize_;
};
inline bool polyesterFactory::titleShadow() {
    return titleshadow_;
};

// polyesterButton //////////////////////////////////////////////////////////

class polyesterButton : public TQButton {
    TQ_OBJECT
public:
    polyesterButton(polyesterClient *parent=0, const char *name=0,
                  const TQString &tip=NULL,
                  ButtonType type=ButtonHelp,
                  int button_size=18,
                  bool squareButton = true,
                  bool toggle=false);
                  //const unsigned char *bitmap=0);
    ~polyesterButton();

    void setBitmap(const unsigned char *bitmap);
    TQSize sizeHint() const;
    ButtonState lastMousePress() const;
    void reset();
    TQImage getButtonImage(ButtonType type);
    virtual void setOn(bool on);
    virtual void setDown(bool on);

protected slots:
    void animate();
    void buttonClicked();
    void buttonReleased();

private:
    void enterEvent(TQEvent *e);
    void leaveEvent(TQEvent *e);
    void mousePressEvent(TQMouseEvent *e);
    void mouseReleaseEvent(TQMouseEvent *e);
    void drawButton(TQPainter *painter);
    void genButtonPix( bool active );

private:
    polyesterClient *client_;
    ButtonType type_;
    int size_;
    double buttonProportions_;
    TQBitmap *deco_;
    TQPixmap *pixmap[2][4];
    TQImage *buttonImgActive;
    TQImage *buttonImgInactive;
    ButtonState lastmouse_;
    bool buttonImgActive_created;
    bool buttonImgInactive_created;
    bool hover_;
    bool m_clicked;
    TQTimer *animTmr;
    uint animProgress;
};

inline TQt::ButtonState polyesterButton::lastMousePress() const {
    return lastmouse_;
}
inline void polyesterButton::reset() {
    repaint(false);
}

// polyesterClient //////////////////////////////////////////////////////////

class polyesterClient : public KDecoration {
    TQ_OBJECT
public:
    polyesterClient(KDecorationBridge *b, KDecorationFactory *f);
    virtual ~polyesterClient();

    virtual void init();

    virtual void activeChange();
    virtual void desktopChange();
    virtual void captionChange();
    virtual void iconChange();
    virtual void maximizeChange();
    virtual void shadeChange();


    virtual void borders(int &l, int &r, int &t, int &b) const;
    virtual void resize(const TQSize &size);
    virtual TQSize minimumSize() const;
    virtual Position mousePosition(const TQPoint &point) const;

    TQPixmap getTitleBarTile(bool active) const
    {
        return active ? *aTitleBarTile : *iTitleBarTile;
    }

private:
    void addButtons(TQBoxLayout* layout, const TQString& buttons, int buttonSize = 18);
    bool eventFilter(TQObject *obj, TQEvent *e);
    void mouseDoubleClickEvent(TQMouseEvent *e);
    void wheelEvent(TQWheelEvent *e);
    void paintEvent(TQPaintEvent *e);
    void resizeEvent(TQResizeEvent *);
    void showEvent(TQShowEvent *);
    void updateMask();
    void _resetLayout();
    int frameSize, titleSize, buttonSize;
    bool roundedCorners;

    TQVBoxLayout *mainLayout_;
    TQHBoxLayout *titleLayout_;
    TQSpacerItem *topSpacer_,
                *titleSpacer_,
                *leftTitleSpacer_, *rightTitleSpacer_,
                *decoSpacer_,
                *leftSpacer_, *rightSpacer_,
                *bottomSpacer_, *windowSpacer_;
    TQPixmap *aCaptionBuffer, *iCaptionBuffer;

private slots:
    void maxButtonPressed();
    void menuButtonPressed();
    void menuButtonReleased();
    void aboveButtonPressed();
    void belowButtonPressed();
    void shadeButtonPressed();
    void keepAboveChange(bool);
    void keepBelowChange(bool);

signals:
    void keepAboveChanged(bool);
    void keepBelowChanged(bool);

private:
    TQPixmap *aTitleBarTile, *iTitleBarTile, *aTitleBarTopTile, *iTitleBarTopTile;
    polyesterButton *button[ButtonTypeCount];
    TQSpacerItem *titlebar_;
    bool pixmaps_created;
    bool closing;
    int s_titleHeight;
    TQFont s_titleFont;
    int handlebar;
    bool maskDirty, aDoubleBufferDirty, iDoubleBufferDirty;
    TQPixmap activeBuff, inactiveBuff;

    void create_pixmaps();
    void delete_pixmaps();
};

} // namespace polyester

#endif // polyester_H
