#ifndef __QTCURVECONFIG_H__
#define __QTCURVECONFIG_H__

/*
  QtCurve (C) Craig Drummond, 2003 - 2010 craig.p.drummond@gmail.com

  ----

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public
  License version 2 as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#define COMMON_FUNCTIONS
#define CONFIG_DIALOG

#include <qtcurveconfigbase.h>
#include <tqcombobox.h>
#include <tqmap.h>
#include "common.h"

#ifdef __cplusplus
using namespace TDEQtCurveStyle;
#endif

class TQPopupMenu;
class TQListViewItem;
class KDoubleNumInput;
#ifdef TQTC_STYLE_SUPPORT
class CExportThemeDialog;
#endif
class CStackItem;
class QtCurveConfig;

class CGradientPreview : public TQWidget
{
    TQ_OBJECT
    

    public:

    CGradientPreview(QtCurveConfig *c, TQWidget *p);

    TQSize sizeHint() const;
    TQSize minimumSizeHint() const;
    void paintEvent(TQPaintEvent *);
    void setGrad(const GradientStopCont &s);

    public slots:

    void setColor(const TQColor &col);

    private:

    QtCurveConfig    *cfg;
    TQColor           color;
    GradientStopCont stops;
};

class QtCurveConfig : public QtCurveConfigBase
{
    TQ_OBJECT
    

    public:

    QtCurveConfig(TQWidget *parent);
    virtual ~QtCurveConfig();

    EShading currentShading() const { return (EShading)shading->currentItem(); }

    signals:

    void changed(bool);

    private:

    void loadStyles(TQPopupMenu *menu);

    public slots:

    void save();
    void defaults();

    private slots:

    void setStyle(int s);
    void updateChanged();
    void focusChanged();
    void roundChanged();
    void importStyle();
    void exportStyle();
    void exportTheme();
    void emboldenToggled();
    void defBtnIndicatorChanged();
    void buttonEffectChanged();
    void coloredMouseOverChanged();
    void shadeSlidersChanged();
    void shadeMenubarsChanged();
    void shadeCheckRadioChanged();
    void customMenuTextColorChanged();
    void menuStripeChanged();
    void comboBtnChanged();
    void sortedLvChanged();
    void stripedProgressChanged();
    void activeTabAppearanceChanged();
    void tabMoChanged();
    void shadingChanged();
    void passwordCharClicked();
    void unifySpinBtnsToggled();
    void unifySpinToggled();
    void sliderThumbChanged();
    void sliderWidthChanged();
    void changeStack();
    void gradChanged(int i);
    void itemChanged(TQListViewItem *i, int col);
    void addGradStop();
    void removeGradStop();
    void updateGradStop();
    void stopSelected();

    private:

    void setupStack();
    void setupGradientsTab();
    void setupShadesTab();
    void setupShade(KDoubleNumInput *w, int shade);
    void populateShades(const Options &opts);
    bool diffShades(const Options &opts);
    void setPasswordChar(int ch);
    void loadStyle(const TQString &file);
    void setOptions(Options &opts);
    void setWidgetOptions(const Options &opts);
    int  getSquareFlags();
    int  getWindowBorderFlags();
    bool settingsChanged();

    private:

    Options            currentStyle,
                       defaultStyle;
    TQMap<int, TQString> styles;
#ifdef TQTC_STYLE_SUPPORT
    CExportThemeDialog *exportDialog;
#endif
    CGradientPreview   *gradPreview;
    GradientCont       customGradient;
    KDoubleNumInput    *shadeVals[NUM_STD_SHADES];
    CStackItem         *lastCategory;
};

#endif
