/**
 * This file is part of the System Settings package
 * Copyright (C) 2005 Benjamin C Meyer (ben+systempreferences at meyerhome dot net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <tdemainwindow.h>
#include <tdecmoduleinfo.h>
#include <ktabwidget.h>
#include <tqptrdict.h>
#include <tqlabel.h>
#include <tdeactionclasses.h>
#include <kiconviewsearchline.h> 

#include "kcscrollview.h"
#include "tdecmodulemenu.h"

class TQWidgetStack;
class TQIconViewItem;
class KCMultiWidget;
class ModulesView;
class TDEAction;
class KWidgetAction;
class TDECModule;
class TDECModuleProxy;

class MainWindow : public TDEMainWindow
{
	TQ_OBJECT
  

public:
	MainWindow(bool embed=true, const TQString &menufile="systemsettings", 
									TQWidget *parent=0, const char *name=0);
	~MainWindow();

private slots:
	void slotItemSelected( TQIconViewItem* item );
	void showAllModules();
	void aboutCurrentModule();
	void updateModuleHelp( TDECModuleProxy * );
	
	void resetModuleHelp();
	void groupModulesFinished();

	void widgetChange();
	void timerResize();
	void slotTopPage();
	void slotSearchHits(const TQString &query, int *hitList, int length);

private:
	TDECModuleMenu *menu;
	bool embeddedWindows;
	TQWidgetStack *windowStack;
	KTabWidget *moduleTabs;

	TQPtrList<ModulesView> modulesViewList;
	TQPtrList<TQIconView> viewList;

	KCMultiWidget *groupWidget;
	KCScrollView *scrollView;

	TQPtrDict<KCMultiWidget> moduleItemToWidgetDict;
	TQPtrDict<KCScrollView> moduleItemToScrollerDict;

	TQPtrList<TDERadioAction> pageActions;
	TQPtrList<KCScrollView> overviewPages;
	int selectedPage;

	TDEAction *resetModule;
	TDEAction *defaultModule;
	
	TDEAction *showAllAction;
	KWidgetAction *searchText;
	TDEAction *searchClear;
	KWidgetAction *searchAction;

	TDEAction *aboutModuleAction;
	
	void buildMainWidget();
	void buildActions();

	TQLabel *generalHitLabel;
	TQLabel *advancedHitLabel;

  /**
   * If someone wants to report a bug
   * against a module with no about data
   * we construct one for him
   **/
  TDEAboutData *dummyAbout;
};

#endif

