/***************************************************************************
 *   KT environment variable editor window header                          *
 *   --------------------------------------------------------------------  *
 *   Copyright (C) 1999, Gary Meyer <gary@meyer.net>                       *
 *   --------------------------------------------------------------------  *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 ***************************************************************************/

#ifndef KTVARIABLE_H
#define KTVARIABLE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqcombobox.h>
#include <tqcheckbox.h>

#include <kdialogbase.h>

class KTextEdit;

class CTVariable;

/**
  * Environment variable editor window.
  */
class KTVariable : public KDialogBase
{
  TQ_OBJECT
  

public:

/**
  * Initialize from CTVariable.
  */
  KTVariable(CTVariable* _ctvar = 0, const TQString &_caption="");

/**
  * Destroy.
  */
  ~KTVariable();

private slots:

/**
  * Variable name has been changed.  Refresh icon.
  */
  void slotVariableChanged();

  /**
   * Apply changes and close.
   */
  void slotOk();

private:

/**
  * Environment variable.
  */
  CTVariable*     ctvar;

  // Widgets.

  TQLabel*         labIcon;

  TQLabel*         labVariable;
  TQComboBox*      cmbVariable;

  TQLabel*         labValue;
  TQLineEdit*      leValue;

  TQLabel*         labComment;
  KTextEdit*      teComment;

  TQCheckBox*      chkEnabled;
};

#endif // KTVARIABLE_H
