// KDat - a tar-based DAT archiver
// Copyright (C) 1998-2000  Sean Vyain, svyain@mail.tds.net
// Copyright (C) 2001-2002  Lawrence Widman, kdat@cardiothink.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#include <time.h>

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqlineedit.h>

#include <tdeapplication.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>

#include "Archive.h"
#include "ArchiveInfoWidget.h"
#include "Options.h"
#include "Tape.h"
#include "Util.h"
#include <tdelocale.h>

#include "ArchiveInfoWidget.moc"

ArchiveInfoWidget::ArchiveInfoWidget( TQWidget* parent, const char* name )
        : TQWidget( parent, name ),
          _archive( 0 )
{
    TQLabel* lbl1 = new TQLabel( i18n( "Archive name:" ), this );
    TQLabel* lbl2 = new TQLabel( i18n( "Created on:" ), this );
    TQLabel* lbl3 = new TQLabel( i18n( "Size:" ), this );

    int max = lbl1->sizeHint().width();
    if ( lbl2->sizeHint().width() > max ) max = lbl2->sizeHint().width();
    if ( lbl3->sizeHint().width() > max ) max = lbl3->sizeHint().width();

    lbl1->setFixedSize( max, lbl1->sizeHint().height() );
    lbl2->setFixedSize( max, lbl2->sizeHint().height() );
    lbl3->setFixedSize( max, lbl3->sizeHint().height() );

    _archiveName = new TQLineEdit( this );
    _archiveName->setFixedHeight( _archiveName->sizeHint().height() );

    _ctime = new TQLabel( "???", this );
    _ctime->setFixedHeight( _ctime->sizeHint().height() );

    _size = new TQLabel( "???", this );
    _size->setFixedHeight( _size->sizeHint().height() );

    _apply = new KPushButton( KStdGuiItem::apply(), this );
    _apply->setFixedSize( 80, _apply->sizeHint().height() );
    _apply->setEnabled( FALSE );

    TQVBoxLayout* l1 = new TQVBoxLayout( this, 4, 4 );

    TQHBoxLayout* l1_1 = new TQHBoxLayout();
    l1->addLayout( l1_1 );
    l1_1->addWidget( lbl1 );
    l1_1->addWidget( _archiveName, 1 );

    TQHBoxLayout* l1_2 = new TQHBoxLayout();
    l1->addLayout( l1_2 );
    l1_2->addWidget( lbl2 );
    l1_2->addWidget( _ctime );

    TQHBoxLayout* l1_3 = new TQHBoxLayout();
    l1->addLayout( l1_3 );
    l1_3->addWidget( lbl3 );
    l1_3->addWidget( _size );

    l1->addStretch( 1 );

    TQHBoxLayout* l1_4 = new TQHBoxLayout();
    l1->addLayout( l1_4 );
    l1_4->addStretch( 1 );
    l1_4->addWidget( _apply );

    connect( _archiveName, TQ_SIGNAL( textChanged( const TQString& ) ), this, TQ_SLOT( slotTextChanged( const TQString& ) ) );
    connect( _apply      , TQ_SIGNAL( clicked() )                 , this, TQ_SLOT( slotApply() ) );
}

ArchiveInfoWidget::~ArchiveInfoWidget()
{
}

void ArchiveInfoWidget::setArchive( Archive* archive )
{
    _archive = archive;

    if ( !_archive ) {
        return;
    }

    _archiveName->setText( _archive->getName() );

    TQString tmp;
    time_t tm = _archive->getCTime();
    tmp = ctime( &tm );
    tmp = tmp.stripWhiteSpace();
    _ctime->setText( tmp );

    int used = _archive->getEndBlock();
    int blockSize = Options::instance()->getTapeBlockSize();
    if ( blockSize < 1024 ) {
        used /= 1024 / blockSize;
    } else if ( blockSize > 1024 ) {
        used *= blockSize / 1024;
    }
    _size->setText( Util::kbytesToString( used ) );
}

void ArchiveInfoWidget::slotTextChanged( const TQString& text )
{
    if ( !_archive ) {
        return;
    }

    _apply->setEnabled( _archive->getName() != text );
}

void ArchiveInfoWidget::slotApply()
{
    if ( !_archive ) {
        return;
    }

    if ( _archive->getName() != _archiveName->text() ) {
        _archive->setName( _archiveName->text() );
    }

    _apply->setEnabled( FALSE );
}
