/***************************************************************************
                          kadddevicecontainer.h  -  description
                             -------------------
    begin                : Wed Jun 15 00:40:33 UTC 2005
    copyright            : (C) 2005 by Juan Luis Baptiste
    email                : juan.baptiste@kdemail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KADDDEVICECONTAINER_H
#define KADDDEVICECONTAINER_H

#include <tqcheckbox.h>
#include <tqgroupbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqradiobutton.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>
#include <kcombobox.h>
#include <kdialog.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <kpassdlg.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kpushbutton.h>

#include "kadddevicedlg.h"
#include "kadddevicedlgextension.h"
#include "kadddevicewifiext.h"
#include "kaddressvalidator.h"

/**
Network interface configuration dialog. This dialog contains the KAddDeviceDlg and KAddDeviceWifiExt widgets.

@author Juan Luis Baptiste
*/
class KAddDeviceContainer : public KDialog
{
  TQ_OBJECT
  
  public:
    KAddDeviceContainer(TQWidget *parent = 0, const char *name = 0);

    ~KAddDeviceContainer();
    KPushButton* kpbAdvanced;
    KPushButton* kpbApply;
    KPushButton* kpbCancel;
    void addButtons();
    KAddDeviceDlg *addDlg;
    KAddDeviceWifiExt *extDlg;
    void addWirelessWidget();
    bool modified();
    bool advanced();

  protected:
    TQVBoxLayout* mainLayout;    
    TQHBoxLayout* buttonsLayout;
    TQSpacerItem* buttonsSpacer;
    TQSpacerItem* widgetHSpacer;    
    bool _modified;
    bool _advanced;    
  
  protected slots:
    void toggleApplyButtonSlot( const TQString & );
    void toggleApplyButtonSlot( int );
    void toggleAdvancedOptionsSlot(bool enabled );
    void verifyDeviceInfoSlot();
    void advancedOptionsSlot();
    void cancelSlot();    
};

#endif
