/***************************************************************************
 *   Copyright (C) 2004 by Juanjo Álvarez                                  *
 *   juanjux@yahoo.es                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef _ALTPARSER_H_
#define _ALTPARSER_H_

#include <config.h>

#include <tqstring.h>
#include <tqobject.h>
#include <tqptrlist.h>
#include <tqstringlist.h>


class Item;

struct Slave
{
    TQString slname;
    TQString slpath;
};

class Alternative
{
    TQString m_altPath;
    TQString m_selectError;
    int m_priority;
    Item *m_parent;
    TQStringList *m_altSlaves;
public:
    Alternative(Item *parentarg);
    Alternative(const Alternative &alt);
    ~Alternative();
    Alternative& operator=(const Alternative &alt);

    Item* getParent() const { return m_parent; }
    TQString getPath() const { return m_altPath; }
    void setPath(const TQString &patharg) { m_altPath = patharg; }
    int getPriority() const { return m_priority; }
    void setPriority(int priorityarg) { m_priority = priorityarg; }
    TQStringList* getSlaves() const { return m_altSlaves; }
    void setSlaves(TQStringList *m_altSlaves);
    void addSlave(const TQString &slave) { m_altSlaves->append(slave); }
    uint countSlaves() const { return m_altSlaves->count(); }
    TQString getSlave(int pos) const { return *(m_altSlaves->at(pos)); }
    bool isSelected() const;
    bool isBroken() const;
    bool select();
    TQString getSelectError() const { return m_selectError; }
};

typedef TQPtrList<Slave> SlaveList;
typedef TQPtrList<Alternative> AltsPtrList;

class Item
{
    TQString m_name;
    TQString m_mode;
    TQString m_path;
    SlaveList *m_itemSlaves;
    AltsPtrList *m_itemAlts;
public:
    Item();
    // Deep copy constructor:
    Item(const Item &item);
    ~Item();
    Item& operator=(const Item &item);

    Alternative* getSelected() const;
    TQString getName() const { return m_name; }
    void setName(const TQString &namearg) { m_name = namearg; }
    TQString getMode() const { return m_mode; }
    //Check the input (FIXME)
    void setMode(const TQString &modearg) { m_mode = modearg; }
    TQString getPath() const { return m_path; }
    void setPath(const TQString &patharg) { m_path = patharg; }
    SlaveList *getSlaves() const { return m_itemSlaves; }
    void setSlaves(SlaveList *slaves);
    void addSlave(const TQString &namearg, const TQString &patharg);
    void delSlave(const TQString &namearg);
    void delSlaveByPath(const TQString &patharg);
    AltsPtrList *getAlternatives() const { return m_itemAlts; }
    Alternative *getAlternative(const TQString &altpath);
    void setAlternatives(AltsPtrList &alts);
    int countAlternatives() const { return m_itemAlts->count(); }
    void delAlternativeByPath(const TQString &patharg);
    void delAlternativeByPriority(int priorityarg);
    void addAlternative(Alternative *altarg) { m_itemAlts->append(altarg); }
    bool isBroken() const;
};

typedef TQPtrList<Item> ItemPtrList;

class AltFilesManager
{
    ItemPtrList *m_itemlist;
    TQString m_altdir;
    TQString m_errorMsg;
    bool m_parseOk;

    bool parseAltFiles(TQString &errorstr);
public:
    AltFilesManager(const TQString &altdir);
    ~AltFilesManager();

    ItemPtrList* getGlobalAlternativeList() const { return this->m_itemlist; }
    bool parsingOk() const { return m_parseOk; }
    TQString getErrorMsg() const { return m_errorMsg; }
    Item* getItem (const TQString &name) const;
    //FIXME: Put in a #ifdef
    void debugPrintAlts() const;
    TQString getAltDir() { return m_altdir ;}
};
#endif // _ALTPARSER_H_
