


#include <tqcstring.h>
#include <tqimage.h>
#include <tqpainter.h>
#include <tqpalette.h>
#include <tqpixmap.h>
#include <tqfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <tqcanvas.h>
#include "qcanvasrectangle_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

TQCanvasRectangleImp::TQCanvasRectangleImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

TQCanvasRectangleImp::~TQCanvasRectangleImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void TQCanvasRectangleImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQCanvasRectangleImp *meth = new TQCanvasRectangleImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void TQCanvasRectangleImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_width_5, "width" },
        { Method_height_6, "height" },
        { Method_setSize_7, "setSize" },
        { Method_size_8, "size" },
        { Method_areaPoints_9, "areaPoints" },
        { Method_rect_10, "rect" },
        { Method_collidesWith_11, "collidesWith" },
        { Method_rtti_12, "rtti" },
	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQCanvasRectangleImp *meth = new TQCanvasRectangleImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a TQCanvasRectangle pointer from an Object.
 */
TQCanvasRectangle *TQCanvasRectangleImp::toTQCanvasRectangle( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        TQObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<TQCanvasRectangle *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "TQCanvasRectangle" )
        return 0;

    return op->toNative<TQCanvasRectangle>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object TQCanvasRectangleImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvasRectangle_1:
             return TQCanvasRectangle_1( exec, args );
             break;

         case Constructor_QCanvasRectangle_2:
             return TQCanvasRectangle_2( exec, args );
             break;

         case Constructor_QCanvasRectangle_3:
             return TQCanvasRectangle_3( exec, args );
             break;

         default:
             break;
    }

    TQString msg = i18n("TQCanvasRectangleCons has no constructor with id '%1'.").arg(id);
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Object TQCanvasRectangleImp::TQCanvasRectangle_1( KJS::ExecState *exec, const KJS::List &args )
{

    // Unsupported parameter TQCanvas *
    return KJS::Object();

    TQCanvas * arg0; // Dummy


    // We should now create an instance of the TQCanvasRectangle object

    TQCanvasRectangle *ret = new TQCanvasRectangle(

          arg0 );


}

KJS::Object TQCanvasRectangleImp::TQCanvasRectangle_2( KJS::ExecState *exec, const KJS::List &args )
{

    TQRect arg0 = extractTQRect(exec, args, 0);

    // Unsupported parameter TQCanvas *
    return KJS::Object();

    TQCanvas * arg1; // Dummy


    // We should now create an instance of the TQCanvasRectangle object

    TQCanvasRectangle *ret = new TQCanvasRectangle(

          arg0,
          arg1 );


}

KJS::Object TQCanvasRectangleImp::TQCanvasRectangle_3( KJS::ExecState *exec, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

    int arg3 = extractInt(exec, args, 3);

    // Unsupported parameter TQCanvas *
    return KJS::Object();

    TQCanvas * arg4; // Dummy


    // We should now create an instance of the TQCanvasRectangle object

    TQCanvasRectangle *ret = new TQCanvasRectangle(

          arg0,
          arg1,
          arg2,
          arg3,
          arg4 );


}

KJS::Value TQCanvasRectangleImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = TQCanvasRectangleImp::toTQCanvasRectangle( self );

    switch( id ) {

    case Method_width_5:
        return width_5( exec, self, args );
        break;

    case Method_height_6:
        return height_6( exec, self, args );
        break;

    case Method_setSize_7:
        return setSize_7( exec, self, args );
        break;

    case Method_size_8:
        return size_8( exec, self, args );
        break;

    case Method_areaPoints_9:
        return areaPoints_9( exec, self, args );
        break;

    case Method_rect_10:
        return rect_10( exec, self, args );
        break;

    case Method_collidesWith_11:
        return collidesWith_11( exec, self, args );
        break;

    case Method_rtti_12:
        return rtti_12( exec, self, args );
        break;

    default:
        break;
    }

    TQString msg = i18n( "TQCanvasRectangleImp has no method with id '%1'." ).arg( id );
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value TQCanvasRectangleImp::width_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->width(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasRectangleImp::height_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->height(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasRectangleImp::setSize_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      instance->setSize(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasRectangleImp::size_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    TQSize ret;
      ret = instance->size(  );

       return convertToValue( exec, ret );

}

KJS::Value TQCanvasRectangleImp::areaPoints_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->areaPoints(  );
      return KJS::Value(); // Returns 'TQPointArray'

}

KJS::Value TQCanvasRectangleImp::rect_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    TQRect ret;
      ret = instance->rect(  );

       return convertToValue( exec, ret );

}

KJS::Value TQCanvasRectangleImp::collidesWith_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter const TQCanvasItem *
    return KJS::Value();

    const TQCanvasItem * arg0; // Dummy

      bool ret;
      ret = instance->collidesWith(
       arg0 );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasRectangleImp::rtti_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->rtti(  );
      return KJS::Number( ret );

}


} // namespace KJSEmbed
