package org.trinitydesktop.koala;

import java.io.*;

/**
 * This marchaller can convert between serialized Qt objects and Java objects.
 *
 * (Scooped the code of Stub.java from the javadcop project, and made the operations static and public)
 */
public class Marchaller {
    // accessor methods for the datatypes used ---------------------------

    public static boolean read_bool(DataInputStream is) throws IOException
    {
	return is.readBoolean();
    }

    public static void write_bool(DataOutputStream os, boolean val) throws IOException
    {
	os.writeBoolean(val);
    }

    public static short read_short_int(DataInputStream is) throws IOException
    {
	return is.readShort();
    }

    public static void write_short_int(DataOutputStream os, short val) throws IOException
    {
	os.writeShort(val);
    }

    public static int read_int(DataInputStream is) throws IOException
    {
	return is.readInt();
    }

    public static void write_int(DataOutputStream os, int val) throws IOException
    {
	os.writeInt(val);
    }

    public static int read_long_int(DataInputStream is) throws IOException
    {
	return is.readInt();
    }

    public static void write_long_int(DataOutputStream os, int val) throws IOException
    {
	os.writeInt(val);
    }

    public static float read_float(DataInputStream is) throws IOException
    {
	return is.readFloat();
    }

    public static void write_float(DataOutputStream os, float val) throws IOException
    {
	os.writeFloat(val);
    }

    public static double read_double(DataInputStream is) throws IOException
    {
	return is.readDouble();
    }

    public static void write_double(DataOutputStream os, double val) throws IOException
    {
	os.writeDouble(val);
    }

    public static String read_QString(DataInputStream is) throws IOException
    {
	int len = is.readInt();
	if (len == 0xffffffff)
	    return new String();
	else
	    {
		StringBuffer b = new StringBuffer();
		for (int i=0; i<len/2; ++i)
		    b.append(is.readChar());
		return b.toString();
	    }
    }

    public static void write_QString(DataOutputStream os, String val) throws IOException
    {
	os.writeInt(val.length()*2);
	for (int i=0; i<val.length(); ++i)
	    os.writeChar(val.charAt(i));
    }

    public static String read_QCString(DataInputStream is) throws IOException
    {
	int len = is.readInt();
	StringBuffer b = new StringBuffer();
	for (int i=0; i<len; ++i)
	    b.append((char)is.readByte());
	return b.toString();
    }

    public static void write_QCString(DataOutputStream os, String val) throws IOException
    {
	os.writeInt(val.length()+1);
	for (int i=0; i<val.length(); ++i)
	    os.writeByte(val.charAt(i));
	os.writeByte(0);
    }

    public static String[] read_QStringList(DataInputStream is) throws IOException
    {
	int n = is.readInt();
	String[] result = new String[n];
	for (int i=0; i<n; ++i)
	    result[i] = read_QString(is);
	return result;
    }

    public static void write_QStringList(DataOutputStream os, String[] val) throws IOException
    {
	os.writeInt(val.length);
	for (int i=0; i<val.length; ++i)
	    write_QCString(os, val[i]);
    }
/*
    public static void write_DCOPRef(DataOutputStream os, DCOPRef ref) throws IOException
    {
	write_QCString(os, ref.app());
	write_QCString(os, ref.object());
	write_QCString(os, ref.type());
    }
    public static DCOPRef read_DCOPRef(DataInputStream is) throws IOException
    {
	return new DCOPRef(read_QCString(is), read_QCString(is), read_QCString(is));
    }
*/
    public static void write_QByteArray(DataOutputStream os, byte[] byteArray) throws IOException
    {
      write_int(os, byteArray.length);
      os.write(byteArray);
    }
}
