/*
 *
 *  Adapter config dialog for tdebluez authentication
 *
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of tdebluezauth.
 *
 *  tdebluezauth is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  tdebluezauth is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */


#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <tdemessagebox.h>
#include <kuniqueapplication.h>
#include <iostream>

#include "application.h"

static const char *description = I18N_NOOP("TDEBluezAuth");
static const char *copy    = I18N_NOOP("Copyright (C) 2018 Emanoil.");

static TDECmdLineOptions options[] =
{
        { 0, 0, 0 }
};

int main(int argc, char *argv[])
{
    TDELocale::setMainCatalogue("tdebluez");
    TDEAboutData aboutData("tdebluezauth",
            I18N_NOOP("TDEBluezAuth"),
            0,
            description, TDEAboutData::License_GPL,
            copy,0, "http://trinitydesktop.org");
    aboutData.addAuthor("Tom Patzig", I18N_NOOP("Author"), "tpatzig@suse.de");
    aboutData.addAuthor("Emanoil Kotsev", I18N_NOOP("Bluez5 and port to TDE"), "deloptes@gmail.com");
    TDECmdLineArgs::init( argc, argv, &aboutData );
    TDECmdLineArgs::addCmdLineOptions( options );
    KUniqueApplication::addCmdLineOptions();

    if (!KUniqueApplication::start())
    {
        std::cerr << i18n("TDEBluezAuth is already running.\n").local8Bit();
        return 0;
    }

    TDEBluezAuth a;

    if (!a.isConnectedToDBUS())
    {
        KMessageBox::error(NULL,i18n("Can't connect to DBus!\nUnable to start tdebluezauth.\n\n"
                                     "Restart dbus and the bluetooth service"));
        KUniqueApplication::kApplication()->quit();
        return -1;
    }
    else
    {
        return a.exec();
    }

}
