/*
    This file is part of tdeio_obex.

    Copyright (c) 2003 Mathias Froehlich <Mathias.Froehlich@web.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef OBEX_H
#define OBEX_H


#include <tdeio/global.h>
#include <tdeio/job.h>
#include <kurl.h>
#include <kuser.h>

#include <tqdbusdata.h>

#include <tqstring.h>

using namespace TDEIO;

class Obex : public TQObject
{
    TQ_OBJECT

public:
	Obex(TQString & mProtocol);
	virtual ~Obex();
	bool parseURL(const KURL &url, TQString &address, TQString &name, TQString &path) const;
	void createTopLevelEntry(UDSEntry &entry);
    void createDirEntry(UDSEntry &entry, const TQString dir);
    UDSEntry createUDSEntry( const TQMap< TQString, TQT_DBusData > &map );
    bool changeWorkingDirectory( const TQString& to );

private slots:
	void slotStatResult(Job *job);

private:

	UDSEntry extractUrlInfos(const KURL &url);
	UDSEntry m_entryBuffer;
    void addAtom(UDSEntry &entry, UDSAtomTypes type, const TQString &s);
    void addAtom(UDSEntry &entry, UDSAtomTypes type, const long l);

    time_t stringToTime_t( TQString );

	long m_effectiveUid;
	TQString mProtocol;
};

#endif
