/* 
 *  Copyright (C) 2004 Girish Ramakrishnan All Rights Reserved.
 *    
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

// $Id: main.cpp,v 1.7 2004/11/08 07:14:18 cs19713 Exp $

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdeglobal.h>
#include <tdelocale.h>

#include <tqdir.h>
#include "tdedocker.h"
#include "traylabelmgr.h"
#include "trace.h"
#include <X11/Xlib.h>

static void sighandler(int sig)
{
  if (sig == SIGUSR1)
  {
    DUMP_TRACE((TQDir::homeDirPath() + "/tdedocker.trace").local8Bit());
    return;
  }

  tqDebug("%s", i18n("Caught signal %1. Cleaning up.").arg(sig).local8Bit().data());
  ((TDEDocker*)TDEApplication::kApplication())->trayLabelMgr()->undockAll();
  TDEApplication::kApplication()->quit();
}

static const TDECmdLineOptions options[] =
{
  { "b", I18N_NOOP("Dont warn about non-normal windows (blind mode)"), 0L },
  { "d", I18N_NOOP("Disable session management"), 0L },
  { "e", I18N_NOOP("Enable session management"), 0L },
  { "f", I18N_NOOP("Dock window that has the focus (active window)"), 0L },
  { "i icon", I18N_NOOP("Custom dock Icon"), 0L },
  { "m", I18N_NOOP("Keep application window mapped (don't hide on dock)"), 0L },
  { "o", I18N_NOOP("Dock when obscured"), 0L },
  { "p secs", I18N_NOOP("Set ballooning timeout (popup time)"), 0L },
  { "q", I18N_NOOP("Disable ballooning title changes (quiet)"), 0L },
  { "t", I18N_NOOP("Remove this application from the task bar"), 0L },
  { "w wid", I18N_NOOP("Window id of the application to dock"), 0L },
  { "!+[command <args>]", I18N_NOOP("Application to dock"), 0 },
  TDECmdLineLastOption
};

//extern "C" int TDE_EXPORT kdemain(int argc, char* argv[])
int main(int argc, char *argv[])
{
  TDEAboutData about("tdedocker", I18N_NOOP("tdedocker"), "1.3",
           I18N_NOOP("Docks any application into the system tray."), TDEAboutData::License_GPL);
  about.addAuthor("John Schember", I18N_NOOP("Original KDocker maintainer"), "john@nachtimwald.com");
  about.addAuthor("Girish Ramakrishnan", I18N_NOOP("Original KDocker developer"), "ramakrishnan.girish@gmail.com");

  TDEGlobal::locale()->setMainCatalogue("tdedocker");

  TDECmdLineArgs::init(argc, argv, &about);
  TDECmdLineArgs::addCmdLineOptions(options);
  TDEDocker::addCmdLineOptions();
  TDEDocker app;

  // setup signal handlers that undock and quit (must be done after the TDEApplication constructor has run)
  signal(SIGHUP, sighandler);
  signal(SIGTERM, sighandler);
  signal(SIGINT, sighandler);
  signal(SIGUSR1, sighandler);

  return app.exec();
}
