#include "kmahjongg.h"
#include "version.h"

#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <kimageio.h>

static const char description[] = I18N_NOOP("Mahjongg for TDE");

int main( int argc, char** argv )
{
    TDEAboutData aboutData( "kmahjongg", I18N_NOOP("KMahjongg"),
      KMAHJONGG_VERSION, description, TDEAboutData::License_GPL,
      "(c) 1997, Mathias Mueller");
    aboutData.addAuthor("Mathias Mueller", I18N_NOOP("Original Author"), "in5y158@public.uni-hamburg.de");
    aboutData.addAuthor("Albert Astals Cid", I18N_NOOP("Current maintainer"), "astals11@terra.es");
    aboutData.addAuthor("David Black", I18N_NOOP("Rewrite and Extension"), "david.black@lutris.com");
    aboutData.addAuthor("Michael Haertjens", I18N_NOOP("Solvable game generation\nbased on algorithm by Michael Meeks in GNOME mahjongg"), "mhaertjens@modusoperandi.com");
    aboutData.addAuthor("Osvaldo Stark", I18N_NOOP("Tile set contributor and web page maintainer"), "starko@dnet.it");
    aboutData.addCredit("Benjamin Meyer", I18N_NOOP("Code cleanup"), "ben+kmahjongg@meyerhome.net");

    TDECmdLineArgs::init( argc, argv, &aboutData );

    TDEApplication a;
    TDEGlobal::locale()->insertCatalogue("libtdegames");
    KImageIO::registerFormats();

    if (a.isRestored())
        RESTORE(KMahjongg)
    else {
        KMahjongg *app = new KMahjongg;
        a.setMainWidget(app);
        app->show();
    }
    return a.exec();
}

