/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2002 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMHEIGHTFIELDEDIT_H
#define PMHEIGHTFIELDEDIT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmsolidobjectedit.h"

class PMHeightField;
class PMFloatEdit;
class TQCheckBox;
class TQComboBox;
class TQLineEdit;
class TQPushButton;

/**
 * Dialog edit class for @ref PMHeightField
 */
class PMHeightFieldEdit : public PMSolidObjectEdit
{
   TQ_OBJECT
  
   typedef PMSolidObjectEdit Base;
public:
   /**
    * Creates a PMHeightFieldEdit with parent and name
    */
   PMHeightFieldEdit( TQWidget* parent, const char* name = 0 );

   /** */
   virtual void displayObject( PMObject* o );

   /** */
   virtual bool isDataValid( );

protected slots:
   /**
    * Slot called when the height field type is changed
    */
   void slotTypeChanged( int t );
   /**
    * Slot called when the file name is changed
    */
   void slotFileNameChanged( const TQString& s );
   /**
    * Slot called when the choose file button is pressed
    */
   void slotFileNameClicked( );

protected:
   /** */
   virtual void createTopWidgets( );
   /** */
   virtual void saveContents( );

private:
   PMHeightField* m_pDisplayedObject;
   TQComboBox* m_pHeightFieldType;
   TQLineEdit* m_pFileName;
   TQPushButton* m_pChooseFileName;
   TQCheckBox* m_pSmooth;
   TQCheckBox* m_pHierarchy;
   PMFloatEdit* m_pWaterLevel;

};


#endif
