/***************************************************************************
 *   Copyright (C) 2003 by Sylvain Joyeux                                  *
 *   sylvain.joyeux@m4x.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef PARSERS_H
#define PARSERS_H

#include <tqstring.h>

namespace TDEIO
{
	class SlaveBase;
}
class TQHtmlStream;
class AptProtocol;

/** Here are defined the functional objects that takes the tokens
 * sent by AptCache and PackageManager objects, and produces HTML */
namespace Parsers
{
	class Parser
  {
  protected:
  	int m_result_count;

    static void attribute_begin(TQHtmlStream& stream, const TQString& text);
    static void attribute_end(TQHtmlStream& stream);

  public:
  	Parser();
  	virtual ~Parser();
  	int result_count() const { return m_result_count; }
  	virtual void operator () (AptProtocol* slave, const TQString& tag, const TQString& value) = 0;
  };

  class Search : public Parser
  {
  public:
  	void operator () (AptProtocol* slave, const TQString& tag, const TQString& value);
  };

  class List : public Parser
  {
    bool m_links;
  public:
    List(bool show_links);
  	void operator () (AptProtocol* slave, const TQString& tag, const TQString& value);
  };

  class FileSearch : public Parser
  {
  public:
  	void operator () (AptProtocol* slave, const TQString& tag, const TQString& value);
  };

  class Show : public Parser
  {
  	TQString m_package, m_installed;
    bool m_act;

  public:
  	Show(const TQString& package, const TQString& installed, bool act);
  	void operator () (AptProtocol* slave, const TQString& tag, const TQString& value);
  };

  class Policy : public Parser
  {
  	TQString m_package, m_installed;
    bool m_has_adept_batch;
    bool m_act;

  public:
    Policy(const TQString& package, bool act);
  	TQString getInstalled() const { return m_installed; }
  	void operator () (AptProtocol* slave, const TQString& tag, const TQString& value);
  };

  void operator << (TDEIO::SlaveBase& slave, const TQCString& string);
  void operator << (TDEIO::SlaveBase& slave, const TQString& string);
  void operator << (TDEIO::SlaveBase& slave, const char* string);

  TQString mangle_version(TQString version);
}

#endif
