/***************************************************************************
    begin                : Mon Feb  4 23:40:41 EST 2002
    copyright            : (C) 2002 - 2004 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef JUK_H
#define JUK_H

#include <tdemainwindow.h>

#include "playermanager.h"

class TQTimer;
class TQListViewItem;

class TDEToggleAction;
class TDESelectAction;
class TDEToolBarPopupAction;
class TDEGlobalAccel;

class SliderAction;
class StatusLabel;
class SystemTray;
class PlayerManager;
class PlaylistSplitter;

class JuK : public TDEMainWindow
{
    TQ_OBJECT
  

public:
    JuK(TQWidget* parent = 0, const char *name = 0);
    virtual ~JuK();
    virtual TDEActionCollection *actionCollection() const;

private:
    void setupLayout();
    void setupActions();
    void setupSystemTray();
    void setupGlobalAccels();
    void createDirs();

    void keyPressEvent(TQKeyEvent *);

    /**
     * readSettings() is separate from readConfig() in that it contains settings
     * that need to be read before the GUI is setup.
     */
    void readSettings();
    void readConfig();
    void saveConfig();

    virtual bool queryExit();
    virtual bool queryClose();

private slots:
    void slotShowHide();
    void slotAboutToQuit();
    void slotQuit();
    void slotToggleSystemTray(bool enabled);
    void slotEditKeys();
    void slotConfigureTagGuesser();
    void slotConfigureFileRenamer();
    void slotUndo();
    void slotCheckAlbumNextAction(bool albumRandomEnabled);
    void slotProcessArgs();

private:
    PlaylistSplitter *m_splitter;
    StatusLabel *m_statusLabel;
    SystemTray *m_systemTray;

    SliderAction *m_sliderAction;
    TDEToggleAction *m_randomPlayAction;
    TDEToggleAction *m_toggleSystemTrayAction;
    TDEToggleAction *m_toggleDockOnCloseAction;
    TDEToggleAction *m_togglePopupsAction;
    TDEToggleAction *m_toggleSplashAction;
    TDEToggleAction *m_loopPlaylistAction;
    TDESelectAction *m_outputSelectAction;

    PlayerManager *m_player;
    TDEGlobalAccel *m_accel;

    bool m_startDocked;
    bool m_showSplash;
    bool m_shuttingDown;
};

#endif
