#include "net.h"
#include <noatun/player.h>
#include <noatun/app.h>

extern "C"
{
	TDE_EXPORT Plugin *create_plugin()
	{
		return new Net();
	}
}


Net::Net() : TQServerSocket(7539, 10), Plugin()
{
	mFDs.setAutoDelete(true);
	connect(napp->player(), TQ_SIGNAL(newSong()), TQ_SLOT(newSong()));
}

Net::~Net()
{
}


void Net::newConnection(int fd)
{
	TQSocket *s=new TQSocket;
	s->setSocket(fd);
	mFDs.append(s);
}

void Net::newSong()
{
	if (!napp->player()->current())
		return;
		
	for (TQSocket *i=mFDs.first(); i!=0; i=mFDs.next())
	{
		TQCString line;
		line=napp->player()->current().title().latin1();
		line+='\n';
		::write(i->socket(), (const void*)line.data(), line.length());
	}
}

void Net::closed()
{
	for (TQSocket *i=mFDs.first(); i!=0; i=mFDs.next())
	{
		if (sender()==i)
			mFDs.removeRef(i);
	}
}



#include "net.moc"
