/*
    msnchatsession.h - MSN Message Manager

    Copyright (c) 2002-2005 by Olivier Goffart        <ogoffart @ kde.org>

    Kopete    (c) 2002-2005 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef MSNMESSAGEMANAGER_H
#define MSNMESSAGEMANAGER_H

#include "kopetechatsession.h"

class MSNSwitchBoardSocket;
class TDEActionCollection;
class MSNInvitation;
class MSNContact;
class TDEActionMenu;
class TQLabel;


/**
 * @author Olivier Goffart
 */
class KOPETE_EXPORT MSNChatSession : public Kopete::ChatSession
{
	TQ_OBJECT
  

public:
	MSNChatSession( Kopete::Protocol *protocol, const Kopete::Contact *user, Kopete::ContactPtrList others, const char *name = 0 );
	~MSNChatSession();

	void createChat( const TQString &handle, const TQString &address, const TQString &auth, const TQString &ID = TQString() );

	MSNSwitchBoardSocket *service() { return m_chatService; };

	void sendFile( const TQString &fileLocation, const TQString &fileName,
		long unsigned int fileSize );

	/**
	 * append an invitation in the invitation map, and send the first invitation message
	 */
	void initInvitation(MSNInvitation* invitation);
	
	virtual void inviteContact(const TQString& );

public slots:
	void slotCloseSession();
	void slotInviteOtherContact();

	void invitationDone( MSNInvitation*  );

	void slotRequestPicture();

	/**
	 * this is a reimplementation of ChatSesstion slot.
	 * the original slot is not virtual, but that's not a problem because it's a slot.
	 */
	virtual void receivedTypingMsg( const TQString &, bool );
	
	void slotConnectionTimeout();

private slots:
	void slotMessageSent( Kopete::Message &message, Kopete::ChatSession *kmm );
	void slotMessageReceived( Kopete::Message &message );

	void slotUserJoined( const TQString &handle, const TQString &publicName, bool IRO );
	void slotUserLeft( const TQString &handle, const TQString &reason );
	void slotSwitchBoardClosed();
	void slotInviteContact( Kopete::Contact *contact );
	void slotAcknowledgement( unsigned int id, bool ack );
	void slotInvitation( const TQString &handle, const TQString &msg );

	void slotActionInviteAboutToShow();

	void slotDisplayPictureChanged();

	/**
	 * (debug)
	 */
	void slotDebugRawCommand();

	void slotSendNudge();
	void slotWebcamReceive();
	void slotWebcamSend();
	void slotSendFile();

	void slotNudgeReceived(const TQString& handle);

private:

	MSNSwitchBoardSocket *m_chatService;
	TQString otherString;
	TDEActionMenu *m_actionInvite;
	TQPtrList<TDEAction> m_inviteactions;
	TDEAction *m_actionNudge;
	TDEAction *m_actionWebcamReceive;
	TDEAction *m_actionWebcamSend;

	//Messages sent before the ending of the connection are queued
	TQValueList<Kopete::Message> m_messagesQueue;
	void sendMessageQueue();
	void cleanMessageQueue( const TQString &reason);
	void startChatSession();

	TQMap<unsigned int, Kopete::Message> m_messagesSent;

	TQMap<long unsigned int, MSNInvitation*> m_invitations;


	/**
	 * weither or not the "has opened a new chat" message need to be sent if the user is typing
	 */
	bool m_newSession;

	TQLabel *m_image;
	TQTimer *m_timeoutTimer;
	uint m_connectionTry;


signals:
	/*
	 * This signal is relayed to the protocol and after, to plugins
	 */
	void invitation(MSNInvitation*& invitation,  const TQString &bodyMSG , long unsigned int cookie , MSNChatSession* msnMM , MSNContact* c );
};

#endif
