
/*
    ircsignalhandler.cpp - Maps signals from the IRC engine to contacts

    Copyright (c) 2004      by Jason Keirstead <jason@keirstead.org>

    Kopete    (c) 2002-2003 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "ircusercontact.h"
#include "ircchannelcontact.h"
#include "ircsignalhandler.h"

#include "kircengine.h"

IRCSignalHandler::IRCSignalHandler(IRCContactManager *m)
	: TQObject(m),
	  manager(m)
{
	KIRC::Engine *m_engine = static_cast<IRCAccount*>( manager->mySelf()->account() )->engine();

	//Channel Connections to ourself
	TQObject::connect(m_engine, TQ_SIGNAL(incomingNamesList(const TQString &, const TQStringList &)),
		this, TQ_SLOT(slotNamesList(const TQString &, const TQStringList &)));

	TQObject::connect(m_engine, TQ_SIGNAL(incomingEndOfNames(const TQString &)),
		this, TQ_SLOT(slotEndOfNames(const TQString &)));

	TQObject::connect(m_engine, TQ_SIGNAL(incomingTopicUser(const TQString &, const TQString &, const TQDateTime &)),
		this, TQ_SLOT(slotTopicUser(const TQString&,const TQString&,const TQDateTime&)));

	//Channel String mappings
	map<IRCChannelContact>( m, TQ_SIGNAL(incomingFailedChankey(const TQString &)),
		&IRCChannelContact::failedChankey );

	map<IRCChannelContact>( m, TQ_SIGNAL(incomingFailedChanFull(const TQString &)),
		&IRCChannelContact::failedChanInvite );

	map<IRCChannelContact>( m, TQ_SIGNAL(incomingFailedChanInvite(const TQString &)),
		&IRCChannelContact::failedChanInvite );

	map<IRCChannelContact>( m, TQ_SIGNAL(incomingFailedChanBanned(const TQString &)),
		&IRCChannelContact::failedChanBanned );

	mapSingle<IRCChannelContact>( m, TQ_SIGNAL(incomingJoinedChannel(const TQString &, const TQString &)),
		&IRCChannelContact::userJoinedChannel );

	mapSingle<IRCChannelContact>( m, TQ_SIGNAL(incomingExistingTopic(const TQString &, const TQString &)),
		&IRCChannelContact::channelTopic );

	mapSingle<IRCChannelContact>( m, TQ_SIGNAL(incomingChannelHomePage(const TQString &, const TQString &)),
		&IRCChannelContact::channelHomePage );

	mapDouble<IRCChannelContact>( m,
		TQ_SIGNAL(incomingPartedChannel(const TQString &, const TQString &,const TQString &)),
		&IRCChannelContact::userPartedChannel );

	mapDouble<IRCChannelContact>( m,
		TQ_SIGNAL(incomingTopicChange(const TQString &, const TQString &,const TQString &)),
		&IRCChannelContact::topicChanged );

	mapDouble<IRCChannelContact>( m,
		TQ_SIGNAL(incomingChannelModeChange(const TQString &, const TQString &,const TQString &)),
		&IRCChannelContact::incomingModeChange );

	mapDouble<IRCChannelContact>( m,
		TQ_SIGNAL(incomingChannelMode(const TQString &, const TQString &,const TQString &)),
		&IRCChannelContact::incomingChannelMode );

	mapTriple<IRCChannelContact>( m,
		TQ_SIGNAL(incomingKick(const TQString &, const TQString &,const TQString &,const TQString &)),
		&IRCChannelContact::userKicked );

	//User connections to ourself
	TQObject::connect(m_engine, TQ_SIGNAL(incomingWhoIsIdle(const TQString &, unsigned long )),
			this, TQ_SLOT(slotNewWhoIsIdle(const TQString &, unsigned long )));

	TQObject::connect(m_engine, TQ_SIGNAL(incomingWhoReply(const TQString &, const TQString &, const TQString &,
		const TQString &, const TQString &, bool, const TQString &, uint, const TQString & )),
		this, TQ_SLOT( slotNewWhoReply(const TQString &, const TQString &, const TQString &, const TQString &,
		const TQString &, bool, const TQString &, uint, const TQString &)));

	//User signal mappings
	map<IRCUserContact>( m, TQ_SIGNAL(incomingUserOnline( const TQString & )), &IRCUserContact::userOnline );

	map<IRCUserContact>( m, TQ_SIGNAL(incomingWhoIsOperator( const TQString & )), &IRCUserContact::newWhoIsOperator );

	map<IRCUserContact>( m, TQ_SIGNAL(incomingWhoIsIdentified( const TQString & )), &IRCUserContact::newWhoIsIdentified );

	map<IRCUserContact>( m, TQ_SIGNAL(incomingEndOfWhois( const TQString & )), &IRCUserContact::whoIsComplete );

	map<IRCUserContact>( m, TQ_SIGNAL(incomingEndOfWhoWas( const TQString & )), &IRCUserContact::whoWasComplete );

	mapSingle<IRCUserContact>( m, TQ_SIGNAL(incomingUserIsAway( const TQString &, const TQString & )),
		&IRCUserContact::incomingUserIsAway );

	mapSingle<IRCUserContact>( m, TQ_SIGNAL(incomingWhoIsChannels( const TQString &, const TQString & )),
		&IRCUserContact::newWhoIsChannels );

	mapDouble<IRCUserContact>( m,
		TQ_SIGNAL(incomingWhoIsServer(const TQString &, const TQString &, const TQString &)),
		&IRCUserContact::newWhoIsServer );

	mapDouble<IRCUserContact>( m,
		TQ_SIGNAL(incomingPrivAction(const TQString &, const TQString &, const TQString &)),
		&IRCUserContact::newAction );

	mapDouble<IRCChannelContact>( m,
		TQ_SIGNAL(incomingAction(const TQString &, const TQString &, const TQString &)),
		&IRCChannelContact::newAction );

	mapTriple<IRCUserContact>( m,
		TQ_SIGNAL(incomingWhoIsUser(const TQString &, const TQString &, const TQString &, const TQString &)),
		&IRCUserContact::newWhoIsUser );

	mapTriple<IRCUserContact>( m,
		TQ_SIGNAL(incomingWhoWasUser(const TQString &, const TQString &, const TQString &, const TQString &)),
		&IRCUserContact::newWhoIsUser );
}

IRCSignalHandler::~IRCSignalHandler()
{
	//Delete our mapping pointers
	for( TQValueList<IRCSignalMappingBase*>::iterator it = mappings.begin(); it != mappings.end(); ++it )
		delete *it;
}

void IRCSignalHandler::slotNamesList( const TQString &chan, const TQStringList &list )
{
	IRCChannelContact *c = manager->existChannel( chan );
	if( c )
		c->namesList( list );
}

void IRCSignalHandler::slotEndOfNames( const TQString &chan )
{
	IRCChannelContact *c = manager->existChannel( chan );
	if ( c )
		c->endOfNames();
}

void IRCSignalHandler::slotTopicUser(const TQString &chan, const TQString &user,const TQDateTime &time)
{
	IRCChannelContact *c = manager->existChannel( chan );
	if( c )
		c->topicUser( user, time );
}

void IRCSignalHandler::slotNewWhoIsIdle(const TQString &nick, unsigned long val )
{
	IRCUserContact *c = manager->findUser( nick );
	if( c )
		c->newWhoIsIdle( val );
}

void IRCSignalHandler::slotNewWhoReply(const TQString &nick, const TQString &arg1, const TQString &arg2,
	const TQString &arg3, const TQString &arg4, bool arg5, const TQString &arg6, uint arg7, const TQString &arg8 )
{
	IRCUserContact *c = manager->findUser( nick );
	if( c )
		c->newWhoReply( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8 );
}

#include "ircsignalhandler.moc"
