/* This file is part of the KDE project
   Copyright (C) 2001 Simon Hausmann <hausmann@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the Artistic License.
*/
#ifndef __ksparser_h__
#define __ksparser_h__

#include <tqcolor.h>
#include <tqmap.h>
#include <tqregexp.h>
#include <tqstring.h>
#include <tqvaluestack.h>

/*
 * Helper class to parse IRC color/style codes and convert them to
 * richtext. The parser maintains an internal stack of the styles
 * applied because the IRC message could contain sequences as
 * (bold)Hello (red)World(endbold)! (blue)blue text
 * which needs to be converted to
 * <b>Hello </b><font color="red"><b>World</b>! </font><font color="blue">blue text</font>
 * to get correctly nested tags. (malte)
 */
class KSParser
{
public:
	static TQCString parse(const TQCString &);
	static int colorForHTML( const TQString &html );

	static TQColor ircColor(const TQString &color);
	static TQColor ircColor(unsigned int color);

	~KSParser();
private:
	KSParser();

	TQCString _parse(const TQCString &);
	TQString pushTag(const TQString &, const TQString & = TQString());
	TQString pushColorTag(const TQColor &fgColor, const TQColor &bgColor);
	TQString popTag(const TQString &);
	TQString toggleTag(const TQString &);
	TQString popAll();

private:
	static KSParser m_parser;
	static const TQColor IRC_Colors[17];
	static const TQRegExp sm_colorsModeRegexp;

	TQValueStack<TQString> m_tags;
	TQMap<TQString, TQString> m_attributes;
};

#endif


