#ifndef SAFEDELETE_H
#define SAFEDELETE_H

#include <tqobject.h>
#include <tqobjectlist.h>

class SafeDelete;
class SafeDeleteLock
{
public:
	SafeDeleteLock(SafeDelete *sd);
	~SafeDeleteLock();

private:
	SafeDelete *_sd;
	bool own;
	friend class SafeDelete;
	void dying();
};

class SafeDelete
{
public:
	SafeDelete();
	~SafeDelete();

	void deleteLater(TQObject *o);

	// same as TQObject::deleteLater()
	static void deleteSingle(TQObject *o);

private:
	TQObjectList list;
	void deleteAll();

	friend class SafeDeleteLock;
	SafeDeleteLock *lock;
	void unlock();
};

class SafeDeleteLater : public TQObject
{
	TQ_OBJECT
  
public:
	static SafeDeleteLater *ensureExists();
	void deleteItLater(TQObject *o);

private slots:
	void explode();

private:
	SafeDeleteLater();
	~SafeDeleteLater();

	TQObjectList list;
	friend class SafeDelete;
	static SafeDeleteLater *self;
};

#endif
