/***************************************************************************
 *
 * tdenetman-devicestore_dbus.h - A NetworkManager frontend for TDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef TDENETWORKMANAGER_CONNECTION_SETTINGS_DIALOG_H
#define TDENETWORKMANAGER_CONNECTION_SETTINGS_DIALOG_H

// tqt headers
#include <tqvaluelist.h>
#include <tqlistview.h>

// tde headers
#include <tdehardwaredevices.h>
#include <tdenetworkconnections.h>

// ui autogenerated headers
#include "connection_settings.h"

class TQWidget;
class Device;

namespace ConnectionSettings
{
	class WidgetInterface;
	class ConnectionSetting;
}

class ConnectionSettingsDialogImpl : public ConnectionSettingsDialog
{
	TQ_OBJECT
  
	public:
		ConnectionSettingsDialogImpl(TDENetworkConnection* conn, bool new_conn, TQByteArray networkextid = TQByteArray(), TQWidget* parent = 0, const char* name = 0, bool modal = false, WFlags fl = 0);
		~ConnectionSettingsDialogImpl();

	public slots:
		void slotConnect();
		void slotCancel();
		void slotSave();
		void slotNext();
		void slotBack();
		void slotEnableButtons();

	signals:
		void connectionSaved();

	public:
		bool _disable_next_button;

	private:
		void updateDialogForDeviceType();
		void createWidgetsForConnection(TDENetworkConnection*, bool new_conn);
		void activateWidget(ConnectionSettings::WidgetInterface* widget);
		void deactivateWidget(ConnectionSettings::WidgetInterface* widget);
		int getDeviceTypeFromConnection(TDENetworkConnection* conn);

		// TODO: To be moved to a factory class
		TQValueList<ConnectionSettings::WidgetInterface*> createWidgetsForWired(TDENetworkConnection* conn, bool new_conn);
		TQValueList<ConnectionSettings::WidgetInterface*> createWidgetsForWireless(TDENetworkConnection* conn, bool new_conn);
		TQValueList<ConnectionSettings::WidgetInterface*> createWidgetsForWirelessKnownESSID(TDENetworkConnection* conn, bool new_conn, const TQByteArray& essid);
		TQValueList<ConnectionSettings::WidgetInterface*> createWidgetsForVPN(TDENetworkConnection* conn, bool new_conn);
		TQValueList<ConnectionSettings::WidgetInterface*> createWidgetsForCDMA(TDENetworkConnection* conn, bool new_conn);
		TQValueList<ConnectionSettings::WidgetInterface*> createWidgetsForGSM(TDENetworkConnection* conn, bool new_conn);

		TDENetworkConnection* _conn;
		TQValueList<int>                 _widgetIds;
		bool _new_conn;
		TQByteArray _networkextid;
};

#endif /* TDENETWORKMANAGER_CONNECTION_SETTINGS_DIALOG_H*/
