/***************************************************************************
 *
 * tdenetman-wireless_manager.h - A NetworkManager frontend for TDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa    <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef TDENETWORKMANAGER_WIRELESS_MANAGER_H
#define TDENETWORKMANAGER_WIRELESS_MANAGER_H

// TQt includes
#include <tqguardedptr.h>
#include <tqmap.h>

// TDENM includes
#include "tdenetman.h"
#include "tdenetman-wireless_network.h"

namespace ConnectionSettings
{
	class WirelessConnection;
}

class WirelessManager
{
	public:
		// get all accesspoints from device dev or from all devices if dev is NULL
		// and group them together using all properties specified in match
		static TQValueList<WirelessNetwork> getWirelessNetworks(TDENetworkDevice* dev = 0, TQ_UINT32 match = WirelessNetwork::MATCH_SSID);

		// get all aps from either one device or from all available devices
		static TQValueList<TDENetworkWiFiAPInfo*> getAccessPoints(TDENetworkDevice* dev = 0);

		// get a list of all known wireless connections
		static TQValueList<TDEWiFiConnection*> getWirelessConnections();

		// get a list of all APs with a specific SSID
		static TQValueList<TDENetworkWiFiAPInfo*> getAccessPointsForEssid(TQByteArray, TDENetworkDevice* dev = 0);

};

#endif /* TDENETWORKMANAGER_WIRELESS_MANAGER_H */
