 /*
    This file is part of tdepim.

    Copyright (C) 2004 Reinhold Kainhofer <reinhold@kainhofer.com>


    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef KABC_EXCHANGEADDRESSBOOKADAPTOR_H
#define KABC_EXCHANGEADDRESSBOOKADAPTOR_H

#include "exchangeglobals.h"

#include <groupwareresourcejob.h>
#include <davaddressbookadaptor.h>

#include <folderlister.h>

#include <tdeabc/addressee.h>
#include <kurl.h>
#include <tqdom.h>

namespace TDEABC {

class ExchangeAddressBookUploadItem : public KPIM::GroupwareUploadItem
{
  public:
    ExchangeAddressBookUploadItem( AddressBookAdaptor *adaptor, TDEABC::Addressee addr, UploadType type );
    virtual ~ExchangeAddressBookUploadItem() {}
/**/    virtual TDEIO::TransferJob *createUploadJob(
            KPIM::GroupwareDataAdaptor *adaptor, const KURL &baseurl );
/**/    virtual TDEIO::TransferJob *createUploadNewJob(
            KPIM::GroupwareDataAdaptor *adaptor, const KURL &baseurl );

  protected:
    ExchangeAddressBookUploadItem( UploadType type ) : KPIM::GroupwareUploadItem( type ) {}
    TQDomDocument mDavData;
};

class ExchangeAddressBookAdaptor : public DavAddressBookAdaptor
{
  public:
    ExchangeAddressBookAdaptor();

    void customAdaptDownloadUrl( KURL &url );
    void customAdaptUploadUrl( KURL &url );
    TQString mimeType() const { return "message/rfc822"; }
    TQCString identifier() const { return "KABCResourceExchange"; }
    TQString defaultNewItemName( KPIM::GroupwareUploadItem *item );
    long flags() const { return GWResBatchDelete; }



    // Creating Jobs
    TDEIO::Job *createListFoldersJob( const KURL &url )
        { return ExchangeGlobals::createListFoldersJob( url ); }
    TDEIO::TransferJob *createListItemsJob( const KURL &url )
        { return ExchangeGlobals::createListItemsJob( url ); }
    TDEIO::TransferJob *createDownloadJob( const KURL &url, KPIM::FolderLister::ContentType ctype )
        { return ExchangeGlobals::createDownloadJob( this, url, ctype ); }
    TDEIO::Job *createRemoveJob( const KURL &uploadurl, const KPIM::GroupwareUploadItem::List &deletedItems )
        { return ExchangeGlobals::createRemoveJob( uploadurl, deletedItems ); }



    // Interpreting Jobs
    bool interpretListItemsJob( TDEIO::Job *job, const TQString &jobData )
       { return ExchangeGlobals::interpretListItemsJob( this, job, jobData ); }
    bool interpretDownloadItemsJob( TDEIO::Job *job, const TQString &jobData )
        { return ExchangeGlobals::interpretAddressBookDownloadItemsJob( this, job, jobData ); }




/**/    KPIM::GroupwareUploadItem *newUploadItem( TDEABC::Addressee addr,
            KPIM::GroupwareUploadItem::UploadType type );




    bool getFolderHasSubs( const TQDomNode &folderNode )
        { return ExchangeGlobals::getFolderHasSubs( folderNode ); }
    KPIM::FolderLister::ContentType getContentType( const TQDomNode &folderNode )
        { return ExchangeGlobals::getContentType( folderNode ); }
};

}

#endif
