/*
 * Copyright (C) 2004, Mart Kelder (mart.kde@hccnet.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MK_KORNBOXCFGIMPL_H
#define MK_KORNBOXCFGIMPL_H

#include "kornboxcfg.h"

class TDEConfig;
class TDEConfigGroup;
class KDialogBase;

class TQFont;
class TQString;
class TQWidget;

class KornBoxCfgImpl : public KornBoxCfg
{ TQ_OBJECT
  
public:
	KornBoxCfgImpl( TQWidget *parent, const char * name );
	~KornBoxCfgImpl();
	
	/**
	 * This method write the current configuration to a specified TDEConfig-object.
	 *
	 * @param config The config where in which the configuration should be added.
	 * @param index The index of the selected config. This is the group-number.
	 */
	void writeConfig( TDEConfig * config, const int index );
	
	/**
	 * This method write the current configuration to a specified TDEConfig-object.
	 *
	 * @param config The config where in which the configuration should be added. Note that this object is stored locally until the object is destroyed.
	 * @param index The index of the selected config. This is the group-number.
	 */
	void readConfig( TDEConfig * config, const int index );
	
private:
	void readViewConfig();
	void readEventConfig();
	void readAccountsConfig();
	void readDCOPConfig();
	
	void writeViewConfig( TDEConfig* config );
	void writeEventConfig( TDEConfig *config );
	void writeAccountsConfig( TDEConfig *config );
	void writeDCOPConfig( TDEConfig *config );
	
	TDEConfig* _config;
	TDEConfigGroup *_group;
	KDialogBase *_base;
	int _index;
	TQString *_anims[ 2 ];
	TQFont *_fonts[ 2 ];
	
protected slots:
	virtual void slotEditBox();
	virtual void slotActivated( const TQString& );
	virtual void slotActivated( const int );
	virtual void slotSetDefaults( const TQString&, const int, TDEConfig* );
	virtual void slotChangeNormalAnim();
	virtual void slotChangeNewAnim();
	virtual void slotChangeNormalFont();
	virtual void slotChangeNewFont();
	virtual void slotNormalAnimToggled( bool enabled );
	virtual void slotNewAnimToggled( bool enabled );
	
private slots:
	void slotOK();
	void slotCancel();
	void slotDialogDestroyed();
	
	void slotAccountsSwapped( int account1, int account2 );
	void slotAccountDeleted( int account );
};

#endif //MK_KORNBOXCFGIMPL_H
