/*
    This file is part of tdepim.

    Copyright (c) 2004 Bo Thorsen <bo@sonofthor.dk>
    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef KMAILCHANGES_H
#define KMAILCHANGES_H

#include <tdeconfigpropagator.h>
#include <tdeconfig.h>

namespace TDEWallet {
  class Wallet;
}

class CreateImapAccount : public TDEConfigPropagator::Change
{
  public:
    class CustomWriter
    {
      public:
        CustomWriter() {}
        virtual ~CustomWriter() {}
        virtual void writeFolder( TDEConfig &, int folderId ) = 0;
        virtual void writeIds( int accountId, int transportId ) = 0;
    };

    CreateImapAccount( const TQString &accountName, const TQString &title );
    ~CreateImapAccount();

    void setServer( const TQString & );
    void setUser( const TQString & );
    void setPassword( const TQString & );
    void setRealName( const TQString & );
    void setPort( int );
    /**
      Set email. Default is "user@server".
    */
    void setEmail( const TQString & );

    void setDefaultDomain( const TQString & );

    void enableSieve( bool );
    void setSieveVacationFileName( const TQString& );
    void enableSavePassword( bool );

    enum Encryption { None, SSL, TLS };
    enum Authentication { NONE, PLAIN, LOGIN, NTLM_SPA, GSSAPI, DIGEST_MD5, CRAM_MD5 };

    void setEncryption( Encryption );
    void setAuthentication( Authentication );

    void setAuthenticationSend( Authentication );

    void setSmtpPort( int );

    void setExistingAccountId( int );
    void setExistingTransportId( int );

    /**
      Set custom writer. CreateImapAccount takes ownerhsip of the
      object.
    */
    void setCustomWriter( CustomWriter * );

  protected:
    bool writeToWallet( const TQString &type, int id );

  protected:
    TQString mAccountName;

    TQString mServer;
    TQString mUser;
    TQString mPassword;
    TQString mRealName;
    int mPort;
    TQString mEmail;
    TQString mDefaultDomain;

    TQString mSieveVacationFileName;
    bool mEnableSieve;
    bool mEnableSavePassword;

    Encryption mEncryption;
    Authentication mAuthentication;
    Authentication mAuthenticationSend;

    int mSmtpPort;

    int mExistingAccountId;
    int mExistingTransportId;

    CustomWriter *mCustomWriter;

  private:
    static TDEWallet::Wallet *mWallet;
};

class CreateDisconnectedImapAccount : public CreateImapAccount
{
  public:
    enum GroupwareType
    {
      GroupwareNone,
      GroupwareKolab,
      GroupwareScalix
    };

    CreateDisconnectedImapAccount( const TQString &accountName );
    virtual void apply();

    void enableLocalSubscription( bool b ) { mLocalSubscription = b; }
    void setGroupwareType( GroupwareType type ) { mGroupwareType = type; }

  private:
    bool mLocalSubscription;
    GroupwareType mGroupwareType;
};

class CreateOnlineImapAccount : public CreateImapAccount
{
  public:
    CreateOnlineImapAccount( const TQString &accountName );
    virtual void apply();
};

#endif
