/***************************************************************************
                          plugin_configuration_dialog.h  -  description
                             -------------------
    begin                : Sam Jun 21 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KRADIO_PLUGIN_CONFIGURATION_DIALOG
#define KRADIO_PLUGIN_CONFIGURATION_DIALOG

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>
#include "widgetplugins.h"

class PluginConfigurationDialog : public KDialogBase,
                                  public WidgetPluginBase
{

TQ_OBJECT
  

public:
    PluginConfigurationDialog(
                 int dialogFace, const TQString &caption,
                 int buttonMask, ButtonCode defaultButton,
                 TQWidget *parent=0, const char *name=0,
                 bool modal=true, bool separator=false);

    // PluginBase

    virtual TQString pluginClassName() const { return "PluginConfigurationDialog"; }

    virtual void   saveState (TDEConfig *) const;
    virtual void   restoreState (TDEConfig *);

protected :

    virtual ConfigPageInfo  createConfigurationPage();
    virtual AboutPageInfo   createAboutPage();

    // WidgetPluginBase

public slots:
            void toggleShown() { WidgetPluginBase::pToggleShown(); }
    virtual void showOnOrgDesktop();
    virtual void show();
    virtual void hide();
    virtual void cancel() { slotCancel(); }

    // TQWidget overrides

protected:
    virtual void showEvent(TQShowEvent *);
    virtual void hideEvent(TQHideEvent *);

    virtual       TQWidget *getWidget()         { return this; }
    virtual const TQWidget *getWidget() const   { return this; }

    TQString m_Caption;
};


#endif
