/***************************************************************************
                          stationlistmetadata.h  -  description
                             -------------------
    begin                : Sat March 29 2003
    copyright            : (C) 2003 by Klas Kalass
    email                : klas@kde.org
    copyright            : (C) 2002 by Martin Witte / Frank Schwanz
    email                : witte@kawo1.rwth-aachen.de / schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef STATIONLISTMETADATA_H
#define STATIONLISTMETADATA_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqstring.h>
#include <tqdatetime.h>

/**
 * Meta Data about a stationlist
 * @author  Martin Witte
 */

class StationListMetaData  {
public:
    TQString    maintainer;
    TQDateTime  lastChange;
    TQString    country;
    TQString    city;
    TQString    media;
    TQString    comment;

    bool operator != (const StationListMetaData &x) const { return !operator ==(x); }
    bool operator == (const StationListMetaData &x) const {
        return maintainer == x.maintainer &&
               lastChange == x.lastChange &&
               country    == x.country &&
               city       == x.city &&
               media      == x.media &&
               comment    == x.comment;
    }
};

#endif
