/***************************************************************************
                          sigslotview.cpp  -  description
                             -------------------
    begin                : Tue May 1 2001
    copyright            : (C) 2001 by Richard Moore
    email                : rich@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqobjectdict.h>
#include <tqobjectlist.h>
#include <tqmetaobject.h>
#include <tqstrlist.h>
#include <tqvariant.h>

#include <tdelocale.h>

#include "sigslotview.h"

SigSlotView::SigSlotView(TQWidget *parent, const char *name ) : TDEListView(parent,name)
{
  addColumn( i18n( "Signals/Slots" ) );

  setRootIsDecorated( true );
  setAllColumnsShowFocus( true );
  setFullWidth( true );
}

SigSlotView::~SigSlotView()
{
}

void SigSlotView::buildList( TQObject *o )
{
  TQMetaObject *mo = o->metaObject();

  TDEListViewItem *sigs = new TDEListViewItem( this, "Signals" );
  TQStrList sigList = mo->signalNames( true );
  TQStrListIterator sigIt( sigList );
  char *si;
  while ( (si=sigIt.current()) != 0 ) {
    ++sigIt;
    new TDEListViewItem( sigs, si /*, "someSignal()"*/ );
  }

  TDEListViewItem *slts = new TDEListViewItem( this, "Slots" );
  TQStrList sltList = mo->slotNames( true );
  TQStrListIterator sltIt( sltList );
  char *sl;
  while ( (sl=sltIt.current()) != 0 ) {
    ++sltIt;
    new TDEListViewItem( slts, sl/*, "someSlot()"*/ );
  }

  setOpen( sigs, false );
  setOpen( slts, false );
}

void SigSlotView::setTarget( TQObject *o )
{
  clear();
  buildList( o );
}

#include "sigslotview.moc"
