/*
    packagelvi.h  -  Custom TQListViewItem that holds a Package object
    
    copyright   : (c) 2001 by Martijn Klingens
    email       : klingens@kde.org

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef PACKAGELVI_H
#define PACKAGELVI_H

#include <tqlistview.h>

#include "package.h"

/**
 * @author Martijn Klingens
 */
class PackageLVI : public TQListViewItem
{
public:
    // Top-level package
    PackageLVI( TQListView *parent , const Package &pkg, const TQString &component );
    // Child component
    PackageLVI( TQListViewItem *parent , const Package &pkg, const TQString &component );

    ~PackageLVI();

    Package& package() { return m_package; }
    void setPackage( const Package &pkg ) { m_package = pkg; }

    TQString component() { return m_component; }
    void setComponent( const TQString &component ) { m_component = component; }
    
private:
    Package m_package;
    TQString m_component;
};
 
#endif // PACKAGELVI_H
