/* This file is part of KCachegrind.
   Copyright (C) 2003 Josef Weidendorfer <Josef.Weidendorfer@gmx.de>

   KCachegrind is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation, version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

/*
 * Some helper functions for TQListViewItem derivates
 */

#ifndef LISTUTILS_H
#define LISTUTILS_H

#include <tqpixmap.h>
#include <tqstring.h>
#include <tqcolor.h>
#include "tracedata.h"

TQString bigNum(SubCost);
TQPixmap colorPixmap(int w, int h, TQColor c);
TQPixmap percentagePixmap(int w, int h, int percent, TQColor c, bool framed);
TQPixmap partitionPixmap(int w, int h, double* hist, TQColor*,
			int maxIndex, bool framed);
TQPixmap costPixmap(TraceCostType* ct, TraceCost* cost, double total, bool framed);

/**
 * A class to calculate the <maxSize> TraceCost items
 * with highest cost.
 */

class HighestCostList
{
 public:
    HighestCostList();
    
    void clear(int maxSize);
    void addCost(TraceCost*, SubCost);
    int count() { return _count; }
    int realCount() { return (_count > _maxSize) ? _maxSize:_count; }
    int maxSize() { return _maxSize; }
    bool hasMore() { return _count > _maxSize; }
    TraceCost* operator[] (int i)
	{ return (i>=0 && i<_count && i<_maxSize) ? _item[i] : 0; }
    
 private:
    TraceCostList _list;
    int _maxSize, _count;
    TraceCostType* _costType;
    TQMemArray<TraceCost*> _item;
    TQMemArray<SubCost> _cost;
};

#endif
