#################################################
#
#  (C) 2010-2011 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

pkg_search_module( APR apr-1 )
if( APR_FOUND )
  set( HAVE_APR 1 )
else( )
  tde_message_fatal( "apr-1 is required, but was not found on your system" )
endif( )


# check for subversion library

check_library_exists( "svn_client-1" "svn_pool_create_ex" "${SVN_LIBRARY_DIR}" HAVE_SVN_POOL_CREATE_EX_SVN_CLIENT )
if( HAVE_SVN_POOL_CREATE_EX_SVN_CLIENT )
  set( SVN_LIBRARIES "svn_client-1;svn_subr-1;svn_ra-1" )
else( )
  check_library_exists( "svn_subr-1" "svn_pool_create_ex" "${SVN_LIBRARY_DIR}" HAVE_SVN_POOL_CREATE_EX_SUBR )
  if( HAVE_SVN_POOL_CREATE_EX_SUBR )
    set( SVN_LIBRARIES "svn_client-1;svn_subr-1;svn_ra-1" )
  else( )
    tde_message_fatal( "svn_client-1 or svn_subr-1 library was not found on your system.\n Subversion is installed?\n Try to set SVN_LIBRARY_DIR to subversion library directory." )
  endif( )
endif( )


# check for subversion headers

tde_save_and_set( CMAKE_REQUIRED_FLAGS "-I${APR_INCLUDE_DIRS}" )
tde_save_and_set( CMAKE_REQUIRED_DEFINITIONS "${APR_CFLAGS}" )

if( SVN_INCLUDE_DIR )
  tde_save_and_set( CMAKE_REQUIRED_INCLUDES "${SVN_INCLUDE_DIR}" )
  check_include_file( "svn_types.h" HAVE_SVN_TYPES_H )
  tde_restore( CMAKE_REQUIRED_INCLUDES )
else( )
  find_file( HAVE_SVN_TYPES_H "subversion-1/svn_types.h" )
  if( HAVE_SVN_TYPES_H )
    get_filename_component( SVN_INCLUDE_DIR ${HAVE_SVN_TYPES_H} PATH CACHE )
  endif( )
endif( )

tde_restore( CMAKE_REQUIRED_FLAGS CMAKE_REQUIRED_DEFINITIONS )

if( NOT HAVE_SVN_TYPES_H )
  tde_message_fatal( "svn_types.h file was not found on your system.\n Subversion devel files are installed?\n Try to set SVN_INCLUDE_DIR to subversion include directory." )
endif( )
