/***************************************************************************
 *   Copyright (C) 2005-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/


#include "tdesvn.h"
#include "commandline.h"
#include "tdesvn-config.h"
#include <tdeapplication.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <kdebug.h>

static const char description[] =
    I18N_NOOP("A Subversion Client for TDE (standalone application)");

static const char version[] = VERSION;

static TDECmdLineOptions options[] =
{
    { "r startrev[:endrev]",I18N_NOOP("Execute single subversion command on specific revision(-range)"),0},
    {"R",I18N_NOOP("Ask for revision when executing single command"),0},
    {"f",I18N_NOOP("Force operation"),0},
    {"o <file>",I18N_NOOP("Save output of subversion command (eg \"cat\") into file <file>"),0},
    {"l <number>",I18N_NOOP("Limit log output to <number>"),0},
    { "+exec <command>",I18N_NOOP("Execute subversion command (\"exec help\" for more information)"),0},
    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    TDECmdLineLastOption
};

int main(int argc, char **argv)
{
    TDEAboutData about("tdesvn", I18N_NOOP("tdesvn"), version, description,
                     TDEAboutData::License_GPL, "(C) 2005-2007 Rajko Albrecht",0,
                         0, "ral@alwins-world.de");
    about.addAuthor( "Rajko Albrecht", 0, "ral@alwins-world.de" );
    about.setHomepage("http://tdesvn.alwins-world.de/");
    about.setBugAddress("tdesvn-bugs@alwins-world.de");

    TDECmdLineArgs::init(argc, argv, &about);
    TDECmdLineArgs::addCmdLineOptions(options);


    TDEApplication app;

    // see if we are starting with session management
    if (app.isRestored())
    {
        RESTORE(tdesvn);
    }
    else
    {
        // no session.. just start up normally
        TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
        if (args->count() == 0)
        {
            tdesvn *widget = new tdesvn;
            widget->show();
            widget->checkReload();
        }
        else
        {
            if (TQString(args->arg(0))==TQString("exec")) {
                kdDebug()<<"Execute a command" << endl;
                CommandLine cl(args);
                return cl.exec();
            } else {
                int i = 0;
                for (; i < args->count(); i++)
                {
                    tdesvn *widget = new tdesvn;
                    widget->show();
                    widget->load(args->url(i),true);
                }
            }
        }
        args->clear();
    }
    return app.exec();
}
