#include <tqcombobox.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>

#include <tdeapplication.h>
#include <tdeversion.h>
#include <kservice.h>
#include <kdebug.h>
#include <tdeconfig.h>


#include "editorchooser_widget.h"


EditorChooserWidget::EditorChooserWidget(TQWidget *parent, const char *name)
        : EditChooser(parent, name)
{
    // ask the trader which editors he has to offer
    m_offers = TDETrader::self()->query("text/plain", "'KTextEditor/Document' in ServiceTypes");

	// remove the vim-part, it's known to crash
	TDETrader::OfferList::Iterator it = m_offers.begin();
	while( it != m_offers.end() )
	{
		if ( ((*it)->desktopEntryName() == "vimpart")
		    || ((*it)->desktopEntryName() == "qeditor_part") )
		{
			m_offers.remove( it );
			break;
		}
		++it;
	}

	load();
	slotEditPartChanged(TQString());
}


void EditorChooserWidget::load()
{
    EditorPart->clear();

    // find the editor to use
    TDEConfig *config = kapp->config();
    config->setGroup("Editor");
    TQString editor = config->readPathEntry("EmbeddedKTextEditor");

    // add the entries to the listview
    TDETrader::OfferList::Iterator it;
    int index=-1, current=0;
    for (it = m_offers.begin(); it != m_offers.end(); ++it)
    {
        EditorPart->insertItem((*it)->name());
        if ( (*it)->desktopEntryName() == editor )
            index = current;
        ++current;
    }

    if (index >=0)
        EditorPart->setCurrentItem(index);

	TQString dirtyAction = config->readEntry( "DirtyAction" );

	if ( dirtyAction == "reload" )
	{
		reload->setChecked( true );
	}
	else if ( dirtyAction == "alert" )
	{
		alert->setChecked( true );
	}
	else
	{
		nothing->setChecked( true );
	}
}


void EditorChooserWidget::save()
{
    TDEConfig *config = kapp->config();
    config->setGroup("Editor");

    TDETrader::OfferList::Iterator it;
    for (it = m_offers.begin(); it != m_offers.end(); ++it)
        if ( EditorPart->currentText() == (*it)->name() )
        {
            config->writePathEntry("EmbeddedKTextEditor", (*it)->desktopEntryName());
        }

	if ( reload->isChecked() )
	{
		config->writeEntry( "DirtyAction", "reload" );
	}
	else if ( alert->isChecked() )
	{
		config->writeEntry( "DirtyAction", "alert" );
	}
	else
	{
		config->writeEntry( "DirtyAction", "nothing" );
	}

    config->sync();
}


void EditorChooserWidget::accept()
{
    save();
}

void EditorChooserWidget::slotEditPartChanged( const TQString & )
{
	TDETrader::OfferList::Iterator it;
	for (it = m_offers.begin(); it != m_offers.end(); ++it)
	{
		if ( EditorPart->currentText() == (*it)->name() )
		{
			external_changes_group->setEnabled( (*it)->desktopEntryName() == "katepart" );
			return;
		}
	}
	external_changes_group->setEnabled( false );
}


#include "editorchooser_widget.moc"




