/***************************************************************************
  copyright            : (C) 2006 by David Nolden
  email                : david.nolden.kdevelop@art-master.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __TYPEDECORATION_H__
#define __TYPEDECORATION_H__


class TypeDecoration {

  public:
	TypeDecoration() {
	}

	///Removes the decoration from the given string
	TypeDecoration( TQString& str ) {
      init( str );
    }

    ~TypeDecoration() {}

	///Removes the decoration from the assigned
	TypeDecoration& operator = ( TQString& str ) {
	  clear();
      init( str );
      return *this;
    }

    TQString apply( const TQString& str ) const {
      TQString ret = str;
      if ( !ret.startsWith( m_decoration_front ) )
        ret = m_decoration_front + ret;

      if ( !ret.endsWith( m_decoration_back ) )
        ret = ret + m_decoration_back;
      return ret;
    }

    void operator += ( const TypeDecoration& rhs ) {
      if ( !m_decoration_front.contains( rhs.m_decoration_front ) )
        m_decoration_front += rhs.m_decoration_front;
      if ( !m_decoration_back.contains( rhs.m_decoration_back ) )
        m_decoration_back += rhs.m_decoration_back;
    }

    void clear() {
      m_decoration_front = TQString();
      m_decoration_back = TQString();
    }

	void  prepend( const TQString& str ) {
		m_decoration_front = str + m_decoration_front;
	}
	
	/*bool smaller( const TypeDecoration& rhs ) const {
	}

	int depth() const {
		
	}*/

  private:
    void init( TQString& str ) {
      str = str.stripWhiteSpace();

      static const TQString cnst = "const";
      static const TQString ref = "&";
	    if ( str.startsWith( cnst ) ) {
		    str.remove( 0, cnst.length() );
		    if( str.isEmpty() || ( !str[0].isLetterOrNumber() && str[0] != '_' ) ) {
				m_decoration_front += cnst + " ";
			    str = str.stripWhiteSpace();
		    } else {
			    str = cnst + str; ///The const was not alone
		    }
	    }

	  if( str.endsWith( cnst ) ) {
		  str.remove( str.length() - cnst.length(), cnst.length() );
		  if( str.isEmpty() || ( !str[str.length()-1].isLetterOrNumber() && str[str.length()-1] != '_' ) ) {
			  m_decoration_back = (m_decoration_back + " " + cnst);
			  str = str.stripWhiteSpace();
		  } else {
			  str = str + cnst; ///The const was not alone
		  }
	  }
	    
	  if ( str.endsWith( ref ) ) {
	      m_decoration_back = ref + m_decoration_back;
		  str = str.remove( str.length() - ref.length(), ref.length() ).stripWhiteSpace();
		  
		  if( str.endsWith( cnst ) ) {
			  str.remove( str.length() - cnst.length(), cnst.length() );
			  if( str.isEmpty() || ( !str[str.length()-1].isLetterOrNumber() && str[str.length()-1] != '_' ) ) {
				  m_decoration_back = m_decoration_back + " " + cnst;
				  str = str.stripWhiteSpace();
			  } else {
				  str = str + cnst; ///The const was not alone
			  }
		  }
	  }
    }

    TQString m_decoration_front, m_decoration_back;
};

#endif 
