/**********************************************************************
** Copyright (C) 2000-2002 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef LISTBOXEDITORIMPL_H
#define LISTBOXEDITORIMPL_H

class TQListBox;
class FormWindow;

#include "listboxeditor.h"

class ListBoxEditor : public ListBoxEditorBase
{
    TQ_OBJECT
  

public:
    ListBoxEditor( TQWidget *parent, TQWidget *editWidget, FormWindow *fw );

protected slots:
    void insertNewItem();
    void deleteCurrentItem();
    void currentItemChanged( TQListBoxItem * );
    void currentTextChanged( const TQString & );
    void okClicked();
    void cancelClicked();
    void applyClicked();
    void choosePixmap();
    void moveItemUp();
    void moveItemDown();
    void deletePixmap();

private:
    TQListBox *listbox;
    FormWindow *formwindow;
    
};

#endif
