#include "uichooser_part.h"

#include <tqvbox.h>

#include <kdialogbase.h>
#include <kdevgenericfactory.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <kdevcore.h>
#include <configwidgetproxy.h>
#include <kdevplugininfo.h>

#include "uichooser_widget.h"

#define UICHOOSERSETTINGSPAGE 1

typedef KDevGenericFactory<UIChooserPart> UIChooserFactory;
static const KDevPluginInfo pluginData("kdevuichooser");
K_EXPORT_COMPONENT_FACTORY( libkdevuichooser, UIChooserFactory( pluginData ) )

UIChooserPart::UIChooserPart(TQObject *parent, const char *name, const TQStringList &)
  : KDevPlugin( &pluginData, parent, name ? name : "UIChooserPart")
{
	setInstance(UIChooserFactory::instance());

	_configProxy = new ConfigWidgetProxy( core() );
	_configProxy->createGlobalConfigPage( i18n("User Interface"), UICHOOSERSETTINGSPAGE, info()->icon() );
	connect( _configProxy, TQ_SIGNAL(insertConfigWidget(const KDialogBase*, TQWidget*, unsigned int )),
		this, TQ_SLOT(insertConfigWidget(const KDialogBase*, TQWidget*, unsigned int )) );
}


UIChooserPart::~UIChooserPart()
{
	delete _configProxy;
}

void UIChooserPart::insertConfigWidget( const KDialogBase * dlg, TQWidget * page, unsigned int pagenumber )
{
	kdDebug() << k_funcinfo << endl;

	if ( pagenumber == UICHOOSERSETTINGSPAGE )
	{
		UIChooserWidget * w = new UIChooserWidget( this, page, "UIChooser widget" );
		connect( dlg, TQ_SIGNAL(okClicked()), w, TQ_SLOT(accept()) );
	}
}




#include "uichooser_part.moc"
