//
// C++ Implementation: clearcasefileinfoprovider
//
// Description:
//
//
// Author: KDevelop Authors <kdevelop-devel@kdevelop.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "clearcasefileinfoprovider.h"
#include "clearcasepart.h"
#include "kdevversioncontrol.h"

#include <kprocess.h>
#include <tqapplication.h>

ClearcaseFileinfoProvider::ClearcaseFileinfoProvider(ClearcasePart *parent)
	: KDevVCSFileInfoProvider( (KDevVersionControl*) parent, "clearcasefileinfoprovider")
{
    vcsInfo_ = NULL;

    connect(parent, TQ_SIGNAL(statusReady(const VCSFileInfoMap&, void*)), TQ_SIGNAL(triggerUpdate(const VCSFileInfoMap&, void*)));

    kdevVCS_ = parent;
}


ClearcaseFileinfoProvider::~ClearcaseFileinfoProvider()
{
}


const VCSFileInfoMap* ClearcaseFileinfoProvider::status( const TQString &dirPath ) {

    if (curDirPath_ == dirPath) return vcsInfo_;

    curDirPath_ = dirPath;

    if (vcsInfo_ != NULL) delete vcsInfo_;
    
    vcsInfo_ = ccManipulator_.retreiveFilesInfos(dirPath);

    return vcsInfo_;
}

bool ClearcaseFileinfoProvider::requestStatus( const TQString &dirPath, void *callerData, bool recursive, bool checkRepos  ) {
 	
    VCSFileInfoMap* vcsDirInfos = ccManipulator_.retreiveFilesInfos(dirPath);

    // update the file tree view
    emit statusReady(*vcsDirInfos, callerData);

    delete vcsDirInfos;
    return true;
}



TQStringList ClearcaseFileinfoProvider::registeredEntryList() const
{
    TQStringList l;
    return l;
}

#include "clearcasefileinfoprovider.moc"
