/***************************************************************************
                          tagmaildlg.cpp  -  description
                             -------------------
    begin                : Sat Nov 24 2001
    copyright            : (C) 2001-2002 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *   (at your option) any later version.                                   *
 ***************************************************************************/


#include "tagmaildlg.h"
#include "listdlg.h"
#include "resource.h"
#include "quantacommon.h"

//kde includes
#include <tdeapplication.h>
#include <kdialog.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdeabc/stdaddressbook.h>

//qt includes
#include <tqlineedit.h>
#include <kpushbutton.h>
#include <tqstringlist.h>
#include <tqregexp.h>


TagMailDlg::TagMailDlg(TQWidget *parent, const char *name)
  :TagMail(parent, name)
{
  setCaption(name);
  setModal(true);

  connect( buttonOk,     TQ_SIGNAL(clicked()), TQ_SLOT(accept()) );
  connect( buttonCancel, TQ_SIGNAL(clicked()), TQ_SLOT(reject()) );
  connect( buttonAddressSelect, TQ_SIGNAL(clicked()), TQ_SLOT(slotSelectAddress()) );
  buttonOk->setIconSet(SmallIconSet("button_ok"));
  buttonCancel->setIconSet(SmallIconSet("button_cancel"));
  lineEmail->setFocus();
}

TagMailDlg::~TagMailDlg(){
}
/** Select a mail address, using the KabApi */
void TagMailDlg::slotSelectAddress()
{
//Based on KMail
  TQString addr, email, emailString;
  TQStringList result;
  TDEABC::AddressBook *addressBook = TDEABC::StdAddressBook::self();
  TDEABC::AddressBook::Iterator it;
  for( it = addressBook->begin(); it != addressBook->end(); ++it ) {
    TQStringList emails = (*it).emails();
    TQString n = (*it).prefix() + " " +
    (*it).givenName() + " " +
    (*it).additionalName() + " " +
          (*it).familyName() + " " +
    (*it).suffix();
    n = n.simplifyWhiteSpace();
    for( unsigned int i = 0; i < emails.count(); ++i ) {
      if (!emails[i].isEmpty()) {
  if (n.isEmpty() || (emails[i].find( "<" ) != -1))
    addr = "";
  else { /* do we really need quotes around this name ? */
    if (n.find(TQRegExp("[^ 0-9A-Za-z\\x0080-\\xFFFF]")) != -1)
      addr = qConfig.attrValueQuotation + n + qConfig.attrValueQuotation + " ";
    else
      addr = n + " ";
  }
  email = emails[i];
  if (!addr.isEmpty() && (email.find( "<" ) == -1)
      && (email.find( ">" ) == -1)
      && (email.find( "," ) == -1))
    addr += "<" + email + ">";
  else
    addr += email;
  addr.stripWhiteSpace();
  result.append( addr );
      }
    }
  }
 result.sort();

 if ( result.count() > 0 )
 {
   ListDlg listDlg(result);
   listDlg.setCaption(i18n("Select Address"));
   if (!listDlg.exec()) return;
   emailString = listDlg.getEntry();
   lineEmail->setText(emailString);
 } else
 {
//Actually this may mean also other erros, but the result is the same for us: cannot get the
//e-mail address
   KMessageBox::error(this,i18n("No addresses found."));
  }
}

#include "tagmaildlg.moc"
