/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_BORROWER_H
#define TELLICO_BORROWER_H

#include "datavectors.h"

#include <ksharedptr.h>

#include <tqdatetime.h>

namespace Tellico {
  namespace Data {

class Loan : public TDEShared {

public:
  Loan(Data::EntryPtr entry, const TQDate& loanDate, const TQDate& dueDate, const TQString& note);
  Loan(const Loan& other);

  Data::BorrowerPtr borrower() const;
  void setBorrower(Data::BorrowerPtr b) { m_borrower = b; }

  const TQString& uid() const { return m_uid; }
  void setUID(const TQString& uid) { m_uid = uid; }

  Data::EntryPtr entry() const;

  const TQDate& loanDate() const { return m_loanDate; }

  const TQDate& dueDate() const { return m_dueDate; }
  void setDueDate(const TQDate& date) { m_dueDate = date; }

  const TQString& note() const { return m_note; }
  void setNote(const TQString& text) { m_note = text; }

  bool inCalendar() const { return m_inCalendar; }
  void setInCalendar(bool inCalendar) { m_inCalendar = inCalendar; }

private:
  Loan& operator=(const Loan&);

  TQString m_uid;
  Data::BorrowerPtr m_borrower;
  Data::EntryPtr m_entry;
  TQDate m_loanDate;
  TQDate m_dueDate;
  TQString m_note;
  bool m_inCalendar;
};

typedef TDESharedPtr<Loan> LoanPtr;
typedef Vector<Loan> LoanVec;
typedef LoanVec::Iterator LoanVecIt;

/**
 * @author Robby Stephenson
 */
class Borrower : public TDEShared {

public:
  Borrower(const TQString& name, const TQString& uid);
  Borrower(const Borrower& other);
  Borrower& operator=(const Borrower& other);

  const TQString& uid() const { return m_uid; }
  const TQString& name() const { return m_name; }
  const LoanVec& loans() const { return m_loans; }
  bool isEmpty() const { return m_loans.isEmpty(); }
  size_t count() const { return m_loans.count(); }

  Data::LoanPtr loan(Data::ConstEntryPtr entry);
  void addLoan(Data::LoanPtr loan);
  bool removeLoan(Data::LoanPtr loan);

private:
  TQString m_name;
  TQString m_uid; // uid used by KABC
  LoanVec m_loans;
};

  } // end namespace
} // end namespace
#endif
