/***************************************************************************
    copyright            : (C) 2001-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_GUI_COMBOBOX_H
#define TELLICO_GUI_COMBOBOX_H

#include <kcombobox.h>

#include <tqvariant.h>
#include <tqvaluelist.h>

class TQString;

namespace Tellico {
  namespace GUI {

/**
 * A combobox for mapping a TQVariant to each item.
 *
 * @author Robby Stephenson
 */
class ComboBox : public KComboBox {
public:
  ComboBox(TQWidget* parent_);

  void clear();
  const TQVariant& currentData() const;
  const TQVariant& data(uint index) const;
  void insertItem(const TQString& string, const TQVariant& datum, int index = -1);
  void insertItems(const TQStringList& strings, const TQValueList<TQVariant>& data, int index = -1);

  // set current item to match data
  void setCurrentData(const TQVariant& data);

private:
  TQValueList<TQVariant> m_data;
};

  } // end namespace
} //end namespace

#endif
